package Local::Utils;

use Modern::Perl;

use Crypt::CBC;
use Digest::SHA1;
use HTML::Escape;
use Data::Printer;
use DateTime::Format::Strptime;

sub symbolise { # transform eg 10/9/l & /ul
    my $string = shift || return; # warn $string;

    my $formatted = HTML::Escape::escape_html($string); # p $formatted;

    $formatted =~ s/(\d)\/ul/$1\/&micro;L/ig;    # /ul
    $formatted =~ s/10\/(6|9)\/(l|kg)/10<sup>$1<\/sup>\/$2/ig; # 10/9/l; 10/6/kg; etc
    $formatted =~ s/10\^(\d)/10<sup>$1<\/sup>/g;         # 10^6; 10^9; etc
		# p $formatted;
    return $formatted;
}

sub sha1_digest {
	my $str = shift; # warn $str;

    my $sha1 = Digest::SHA1->new;
    $sha1->add($str);
    return $sha1->b64digest; # same as:
    # return Digest::SHA1::sha1_base64($str); # Digest::MD5::md5_hex($str)
}

sub time_now {
    my $args = shift || {}; # p $args; # optional args for DT constructor
    $args->{time_zone} ||= 'Europe/London';
    # default format "yyyy-mm-dd hr:min:sec" if called as time_now() ie without ->function:
    $args->{formatter} ||= DateTime::Format::Strptime->new( pattern => '%F %T' );
    return DateTime->now(%$args);
}

sub today { time_now(@_) } # just returns time_now()

sub this_year { time_now(@_)->year }

sub encrypt { # Crypt::CBC
    my ($str, $key) = @_;
    my $cipher = Crypt::CBC->new({ key => $key });
    return $cipher->encrypt_hex($str);
}

sub decrypt { # Crypt::CBC
    my ($str, $key) = @_; # p [$str, $key];
    my $cipher = Crypt::CBC->new({ key => $key });
    return $cipher->decrypt_hex($str);
}

# transforms DateTime object, or (recursive) hashref of keys with value(s) DateTime: 
sub datetime_to_string {
    my $r = shift; # say ref $r;
	# return stringified if DT object:
	return "$r" if ref($r) =~ /^DateTime/;
	# return unless hashref:
    return unless ref($r) eq 'HASH';

    for my $key ( keys %$r ) {
        if ( ref($r->{$key}) eq 'HASH' ) { # recursive call for hashrefs
            datetime_to_string( $r->{$key} ); # p $r->{$key};
        }
        if ( ref($r->{$key}) =~ /^DateTime/ ) { # p $r->{$key};
            $r->{$key} = sprintf "%s", $r->{$key}; # quote to force to string
        }
    }
	return $r;
}

1;
