package Labels;

use Dancer2;
use Labels::Model;

use Data::Dumper;
use Data::Printer;

our $VERSION = '0.1';

set auto_page => 1; # don't need routes for static tt returns (labels)

hook before => sub {
    my $vars = params; # p settings('environment');
    p $vars if setting('environment') eq 'development';
};

get '/' => sub { template 'index', {}, { layout => 'default' } };

post '/labels' => sub {
    my $src_file = upload('src_file'); # p $src_file;

	my $valid = _validate_user_input($src_file);
    unless ( $valid ) {
        debug 'have upload error';
        return template VEP_INPUT_TT, {
            title => 'Upload Data Error',
            warning_message => 'You must upload the file again!',
            %$input,
        };
    }
	
    my @args = ( content => $src_file->content,	config => config() ); # p @args;
	my $o = Labels::Model->new(@args);
	$o->parse_xls();
	$o->print_labels();
};

#-------------------------------------------------------------------------------
sub _validate_user_input {
    my $src_file = shift || return 'No data file uploaded!';
 
    # check that the file is a valid data file:
	return 'Not a valid data file!'
		unless lc $src_file->filename =~ /\.xls\Z/;
}

true;
