package MaleCustomer;

=begin
Male customers come for a simple haircut. This takes 15 minutes and they pay 12
for it.  They are willing to wait for between 30 and 90 minutes. However, when
they see that a single customer before them is served for longer than 35 minutes,
they become frustrated and leave immediately
=cut

use Scalar::Util qw(looks_like_number);

use constant TIME => 15; # for a haircut
use constant COST => 12;

use Moo;
extends 'Customer';

has tolerance => ( 
    is => 'rw', 
    isa => sub { 
        looks_like_number $_[0] or die "$_[0] is not a number!";
        die "Not between 30 and 90 mins" unless grep $_[0] == $_, 30..90;
    },   
    required => 1,
);

sub wait { shift->tolerance }

sub hasLeft {

}

sub getRequiredTime { TIME }

sub getPayment { COST }

no Moose;
__PACKAGE__->meta->make_immutable;

1;