package FemaleCustomer;

=begin
Female customers ask for more sophisticated services, which will take the hairdresser 
between 20 and 50 minutes. They pay a flat fee of 25, and wait up to 120 minutes.
=cut

use Scalar::Util qw(looks_like_number);

use constant WAIT => 120;
use constant COST => 25;

use Moo;
extends 'Customer';

has requiredTime => ( # for a haircut
    is => 'rw', 
    isa => sub { 
        looks_like_number $_[0] or die "$_[0] is not a number!";
        die "Not between 20 and 50 mins" unless grep $_[0] == $_, 20..50;    
    },   
    required => 1,
);

sub wait { WAIT }

sub hasLeft {

}

sub getRequiredTime { shift->requiredTime }

sub getPayment { COST }

no Moose;
__PACKAGE__->meta->make_immutable;

1;