package LIMS::DB::Outreach::PainOption;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'pain_options',

    columns => [
        id     => { type => 'integer', not_null => 1 },
        option => { type => 'varchar', length => 25 },
    ],

    primary_key_columns => [ 'id' ],

    relationships => [
        questionnaire_pain => {
            class      => 'LIMS::DB::Outreach::QuestionnairePain',
            column_map => { id => 'pain_option_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('pain_options');

1;
