package LIMS::Controller::Admin::Config::ErrorCodes;

use base 'LIMS::Base';
use LIMS::Local::Sugar;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# -------------------------------------------------------------------------------------
startmode default ($errs) {
    $self->_debug_path($self->get_current_runmode); # $self->stash(errs => $errs);

    my $error_codes = $self->model('ErrorCode')->get_error_codes;

	my $report_error_codes = $self->model('ErrorCode')->get_report_error_codes;
	
	# report_codes in use:
	my %codes_map = map {
		$_->code => $_->id,
	} @$report_error_codes;

    $self->tt_params(
		error_codes => $error_codes,
		codes_map   => \%codes_map,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('error_codes');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode edit ($errs, $id) {
    $self->_debug_path($self->get_current_runmode);

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('ErrorCode')->get_error_code($id);

    $self->tt_params(
        errs => $errs,
		data => $data,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('error_codes');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);

	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

	# if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('error_codes') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) {
		$data->{id} = $id;
	}

    my $rtn = $self->model('ErrorCode')->update_error_codes($data); # warn $rtn;

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/config/error-codes' );
}

# -------------------------------------------------------------------------------------
runmode configure ($errs) {
    $self->_debug_path($self->get_current_runmode);

    my $error_codes = $self->model('ErrorCode')->get_error_codes;

	my $error_codes_config
		= $self->model('Base')->get_objects('ErrorCodeAssignment');
	
    my %config_map = ();
    
    map {
        my $type = $_->type; # warn $type;
        my $error_code_id = $_->error_code_id; # warn $error_code_id;
        
        $config_map{$type}{$error_code_id} = 1;
    } @$error_codes_config;
    
    $self->tt_params(
		error_codes => $error_codes,
		config_map  => \%config_map,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('error_codes_config');

    return $self->tt_process('admin/config/errorcodes/config.tt', $errs);
}

# -------------------------------------------------------------------------------------
runmode update_assignments {
    $self->_debug_path($self->get_current_runmode);

	my $dfv = $self->check_rm('default', $self->validate('error_codes_config') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid; 

    my $rtn = $self->model('ErrorCode')->update_error_code_assignments($data); # warn $rtn;

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('admin')->{error_code}->{config_update} );
	    return $self->redirect( $self->query->url . '/config/error-codes/configure' );
	}
}

1;