#!/usr/bin/env perl

=begin -------------------------------------------------------------------------
diagnosis = 'awaiting final diagnosis'
=cut ---------------------------------------------------------------------------

use strict;
use warnings;

my $JUST_TESTING = 0; # email to ra.jones only

################################################################################
my @recipients = qw( douglas oconnor raj );
my $duration = 7; # how many calendar days since authorisation
################################################################################

BEGIN {
    use FindBin qw($Bin); # warn $Bin;
    use lib (
        "$Bin/../../../lib",
        '/home/raj/perl5/lib/perl5',
    );
}

use Data::Dumper;
use LIMS::Local::ScriptHelpers;

# get tools from LIMS::Local::ScriptHelpers:
my $tools = LIMS::Local::ScriptHelpers->new();
$tools->test_only($JUST_TESTING);

my $sql_lib = $tools->sql_lib();
my $config  = $tools->config();
my $dbix    = $tools->dbix();

my $query = $sql_lib->retr('awaiting_final_diagnosis');
my $result = $dbix->query($query, $duration)->hashes;
exit unless @$result; # warn ref $result;

# email subject line:
my $subject = sprintf 'Awaiting final diagnosis [%s]', scalar @$result;
# template:
my $tmpl  = 'cron/awaiting_final_diagnosis.tt';

my $message = $tools->process_template($tmpl, { data => $result });

my %mail = (
    content => 'html',
	config  => $config,
	message => $message,
	subject => $subject,
); # warn Dumper \%mail; exit;

$tools->send_mail(\%mail, \@recipients);
