package LIMS::Model::Roles::HistoryAction;

# provides 'action' for Role::ReportUpdate & Role::RequestUpdate
# allows both Roles to be used together by any parent class

use Moose::Role;

has actions => (
    is         => 'ro',
    isa        => 'ArrayRef[Str]',
    default    => sub { [] },
    lazy    => 1,
	traits  => ['Array'],
	handles => {
		add_to_actions => 'push',
		all_actions    => 'elements',
	},
);

sub do_request_history {
    my $self = shift;
    
    my $request_id = $self->form_data->{_request_id};
    my $user_id    = $self->user_profile->{id};

    for my $action ($self->all_actions) { # warn $action;
        LIMS::DB::RequestHistory->new(
            request_id => $request_id,
            user_id    => $user_id,
            action     => $action,
        )->save;
    }   
}

1;