package LIMS::Local::PDF;

use Moose;
has path => ( is => 'ro', isa => 'Str', required => 1);
__PACKAGE__->meta->make_immutable;

use HTML::HTMLDoc;

sub make_pdf {
    my $self = shift;
    my $args = shift;
    
    my $htmldoc = new HTML::HTMLDoc(mode => 'file', tmpdir =>'/tmp');

    { # logo:
        my $logo = $self->path . '/images/logo.jpeg';
        $htmldoc->set_logoimage($logo);
        $htmldoc->set_header('.', '.', 'l'); # positions; '.' = null; 'l' = logo
    }
    { # format:
        $htmldoc->set_bodyfont('Times');
        $htmldoc->set_fontsize(10);
        $htmldoc->set_top_margin(10, 'mm');
        $htmldoc->set_left_margin(15, 'mm');
        $htmldoc->set_right_margin(15, 'mm');
        $htmldoc->set_bottom_margin(10, 'mm');
        # naughty, but setting not otherwise available:
        $htmldoc->_set_doc_config('headfootsize', 9);
        # $htmldoc->set_footer('t', 'd', '1'); # doesn't work
    }

    if (my $html = $args->{html}) {
        $htmldoc->set_html_content($html); # or $htmldoc->set_input_file($filename);
    }
    elsif (my $filename = $args->{file}) { # warn $filename;
        $htmldoc->set_input_file('/tmp/'.$filename);
        #my $pdf = `/home/raj/www/perl-lib/wkhtmltopdf/wkhtmltopdf /tmp/$filename -`;
        #return $pdf;
    }    
   
    my $pdf = $htmldoc->generate_pdf(); # my @errs =  $htmldoc->error(); warn @errs if @errs;

    return $pdf->to_string(); # $pdf->to_file('foo.pdf'); 
}

1;

