package LIMS::DB::UserGroup;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'user_groups',

    columns => [
        id           => { type => 'serial', not_null => 1 },
        group_name   => { type => 'varchar', length => 10 },
        group_label  => { type => 'varchar', length => 30 },
        group_detail => { type => 'varchar', length => 255 },
        active	     => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'group_label' ],
        [ 'group_name' ],
    ],

    relationships => [
        user_group_function => {
            class      => 'LIMS::DB::UserGroupFunction',
            column_map => { id => 'group_id' },
            type       => 'one to many',
        },

        users => {
            class      => 'LIMS::DB::User',
            column_map => { id => 'group_id' },
            type       => 'one to many',
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2, braces => 'bsd');

__PACKAGE__->meta->make_manager_class('user_groups');

1;
