package LIMS::DB::DiagnosticCategory;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'diagnostic_categories',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        description   => { type => 'varchar', length => 255 },
        category_type => { type => 'enum', check_in => [ 'main', 'sub' ] },
        active        => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    relationships => [
        diagnoses => {
            class      => 'LIMS::DB::Diagnosis',
            column_map => { id => 'diagnostic_category_id' },
            type       => 'one to many',
        },
        icdo3_category => {
            class      => 'LIMS::DB::ICDO3Category',
            column_map => { id => 'diagnostic_category_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('diagnostic_categories');

1;