package LIMS::Controller::Resources;

use Moose;
BEGIN { extends 'LIMS::Base'; }
with (
    'LIMS::Controller::Roles::DataMap',
    'LIMS::Controller::Roles::DataFile',
);
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

use Data::Dumper;

#-------------------------------------------------------------------------------
sub menu : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->tt_process;
}

#-------------------------------------------------------------------------------
sub list_all_screen_tests : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $all_assigned_tests = $self->model('Screen')->get_all_assigned_tests;

    my %tests;

    while (my $test = $all_assigned_tests->next) { # $self->debug($test);
        my $description = $test->screen->description;
        my $field_label = $test->lab_test->field_label;

        push @{ $tests{$description} }, $field_label;
    }

    $self->tt_params(
        tests => \%tests,
    );

    return $self->tt_process;
}

#-------------------------------------------------------------------------------
sub data_file : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;
  
    return $self->forbidden() unless $self->user_can('do_admin');
    return $self->tt_process('resources/new_data_file.tt', { error => $errs });
}

#-------------------------------------------------------------------------------
sub active_sessions : Runmode {
    my $self = shift;
    
    my $args = { sort_by => 'time desc' };
    my $sessions = $self->model('Base')->get_objects('Session', $args);
    
    $self->tt_params( sessions => $sessions );
    return $self->tt_process;
}

#-------------------------------------------------------------------------------
sub get_data_file : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->forbidden() unless $self->user_can('do_admin');
    
    my $method = $self->param('id'); # warn $method;
    
    if ($method eq 'url') {
        return $self->data_file_from_url; # Role::DataFile
    }
    elsif ($method eq 'upload') {
        return $self->data_file_from_upload; # Role::DataFile
    }
    else {
        return $self->forward('data_file');
    }       
}

#-------------------------------------------------------------------------------
sub new_diagnoses : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    { # get list of locations from email_contacts table:
        my $locations_map = $self->user_locations_map;
        $self->tt_params( locations => $locations_map );
    }

    # if we have an org_code to search on:
    if ( my $org_code = $self->query->param('org_code') ) {
         my $duration = $self->query->param('duration') || 7; # default
    
        my %args = (
            org_code => $org_code,
            duration => $duration,
        );
        
        my $data = $self->model('Request')->get_new_and_relapsed_cases(\%args);
        # sort data by report_history.time since Rose can't do it:
        my @sorted = sort { # warn Dumper $a->request_history->time;
            my $A = $a->request_history->[0]->time->truncate( to => 'day' ); 
            my $B = $b->request_history->[0]->time->truncate( to => 'day' );
			
            DateTime->compare( $A, $B ) # date 1st 
                || $a->year <=> $b->year # year 2nd
                    || $a->request_number <=> $b->request_number; # req_no 3rd	
        } @$data;
        
        $self->tt_params( results => \@sorted );
    }
    
    return $self->tt_process();
}

1;
