-- --------------------------------------------------------
-- Host:                         163.160.171.164
-- Server version:               5.0.67-log - SUSE MySQL RPM
-- Server OS:                    suse-linux-gnu
-- HeidiSQL Version:             8.1.0.4545
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table outreach.defaults_and_ranges
CREATE TABLE IF NOT EXISTS `defaults_and_ranges` (
  `param_id` smallint(6) NOT NULL default '0',
  `lower_limit` decimal(10,2) default NULL,
  `upper_limit` decimal(10,2) default NULL,
  `default` decimal(10,2) default NULL,
  `lower_flag` decimal(10,2) default NULL,
  `upper_flag` decimal(10,3) default NULL,
  `units` varchar(255) default NULL,
  PRIMARY KEY  (`param_id`),
  CONSTRAINT `defaults_and_ranges_ibfk_1` FOREIGN KEY (`param_id`) REFERENCES `lab_params` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.diagnoses
CREATE TABLE IF NOT EXISTS `diagnoses` (
  `diagnosis_id` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`diagnosis_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.followup_options
CREATE TABLE IF NOT EXISTS `followup_options` (
  `id` smallint(6) NOT NULL auto_increment,
  `option` varchar(20) default NULL,
  `label` varchar(25) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.lab_params
CREATE TABLE IF NOT EXISTS `lab_params` (
  `id` smallint(6) NOT NULL auto_increment,
  `param_name` varchar(25) NOT NULL default '',
  `field_label` varchar(255) NOT NULL default '',
  `field_type` enum('menu','int','decimal') default 'int',
  `department_id` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `param_name` (`param_name`),
  KEY `department_id` (`department_id`),
  CONSTRAINT `lab_params_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `result_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.menu_options
CREATE TABLE IF NOT EXISTS `menu_options` (
  `field_name` varchar(255) NOT NULL,
  `detail` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`field_name`,`detail`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.nodal_options
CREATE TABLE IF NOT EXISTS `nodal_options` (
  `id` smallint(6) NOT NULL auto_increment,
  `option` varchar(25) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.non_participant_practice
CREATE TABLE IF NOT EXISTS `non_participant_practice` (
  `practice_id` int(6) NOT NULL default '0',
  PRIMARY KEY  (`practice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.notification_events
CREATE TABLE IF NOT EXISTS `notification_events` (
  `id` smallint(6) NOT NULL auto_increment,
  `days` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `event` (`days`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.pain_options
CREATE TABLE IF NOT EXISTS `pain_options` (
  `id` smallint(6) NOT NULL auto_increment,
  `option` varchar(25) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.patient_alternate_address
CREATE TABLE IF NOT EXISTS `patient_alternate_address` (
  `patient_id` int(11) NOT NULL default '0',
  `address` varchar(255) NOT NULL default '',
  `post_code` varchar(8) NOT NULL default '',
  PRIMARY KEY  (`patient_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.


-- Dumping structure for table outreach.patient_dispatch_detail
CREATE TABLE IF NOT EXISTS `patient_dispatch_detail` (
  `patient_id` int(11) NOT NULL default '0',
  `dispatch_to` enum('home','alternate','GP') NOT NULL default 'home',
  PRIMARY KEY  (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.practice_blood_tube
CREATE TABLE IF NOT EXISTS `practice_blood_tube` (
  `practice_id` smallint(6) NOT NULL default '0',
  `tube_type` enum('vacutainer','monovette') default NULL,
  `time` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`practice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Data exporting was unselected.


-- Dumping structure for table outreach.questionnaire_adenopathy
CREATE TABLE IF NOT EXISTS `questionnaire_adenopathy` (
  `request_id` int(11) NOT NULL default '0',
  `nodal_option_id` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`request_id`,`nodal_option_id`),
  KEY `nodal_options` (`nodal_option_id`),
  CONSTRAINT `fk_questionnaire_adenopathy` FOREIGN KEY (`nodal_option_id`) REFERENCES `nodal_options` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.questionnaire_eq5d
CREATE TABLE IF NOT EXISTS `questionnaire_eq5d` (
  `request_id` int(11) NOT NULL,
  `mobility` enum('A','B','C') default NULL,
  `self_care` enum('A','B','C') default NULL,
  `usual_activity` enum('A','B','C') default NULL,
  `discomfort` enum('A','B','C') default NULL,
  `anxiety` enum('A','B','C') default NULL,
  `health_index` smallint(3) default NULL,
  PRIMARY KEY  (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.questionnaire_pain
CREATE TABLE IF NOT EXISTS `questionnaire_pain` (
  `request_id` int(11) NOT NULL default '0',
  `pain_option_id` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`request_id`,`pain_option_id`),
  KEY `pain_options` (`pain_option_id`),
  CONSTRAINT `fk_questionnaire_pain` FOREIGN KEY (`pain_option_id`) REFERENCES `pain_options` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.questionnaire_service
CREATE TABLE IF NOT EXISTS `questionnaire_service` (
  `request_id` int(11) NOT NULL default '0',
  `opinion` enum('happy','unhappy') default NULL,
  PRIMARY KEY  (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.questionnaire_symptoms
CREATE TABLE IF NOT EXISTS `questionnaire_symptoms` (
  `request_id` int(11) NOT NULL default '0',
  `weight_loss` enum('Y','N','U') default 'U',
  `night_sweats` enum('none','occasional','frequent','drenching','unstated') default 'unstated',
  `adenopathy` enum('none','stable','unstable','unstated') default 'unstated',
  `pain` enum('none','stable','unstable','unstated') default 'unstated',
  PRIMARY KEY  (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.request_followup
CREATE TABLE IF NOT EXISTS `request_followup` (
  `request_id` int(11) NOT NULL default '0',
  `followup_option_id` smallint(6) NOT NULL default '0',
  `time` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`request_id`),
  KEY `followup_option_id` (`followup_option_id`),
  CONSTRAINT `request_followup_ibfk_1` FOREIGN KEY (`followup_option_id`) REFERENCES `followup_options` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.request_notification
CREATE TABLE IF NOT EXISTS `request_notification` (
  `request_id` int(11) NOT NULL default '0',
  `event_id` smallint(6) NOT NULL,
  `time` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`request_id`),
  KEY `request_notification_ibfk_1` (`event_id`),
  CONSTRAINT `request_notification_ibfk_1` FOREIGN KEY (`event_id`) REFERENCES `notification_events` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.request_pack_dispatch
CREATE TABLE IF NOT EXISTS `request_pack_dispatch` (
  `request_id` int(11) NOT NULL default '0',
  `pack_due` date default NULL,
  `pack_sent` date default NULL,
  `return_due` date default NULL,
  `time` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.request_results
CREATE TABLE IF NOT EXISTS `request_results` (
  `request_id` int(11) NOT NULL default '0',
  `param_id` smallint(6) NOT NULL default '0',
  `result` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`request_id`,`param_id`),
  KEY `request_results_ibfk_1` (`param_id`),
  CONSTRAINT `request_results_ibfk_1` FOREIGN KEY (`param_id`) REFERENCES `lab_params` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach.result_types
CREATE TABLE IF NOT EXISTS `result_types` (
  `id` smallint(6) NOT NULL auto_increment,
  `description` varchar(25) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Data exporting was unselected.
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
