package LIMS::DB::RequestStorage;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'request_storage',

    columns => [
        vial_id     => { type => 'varchar', length => 10, not_null => 1 },
        request_id  => { type => 'integer', not_null => 1 },
        specimen_id => { type => 'integer', not_null => 1 },
        rack_id     => { type => 'varchar', length => 10, default => '' },
        created_at  => { type => 'timestamp', not_null => 1 },
        signed_out  => { type => 'timestamp' },
    ],

    primary_key_columns => [ 'vial_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },

        specimen => {
            class       => 'LIMS::DB::Specimen',
            key_columns => { specimen_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_storage');

1;