package LIMS::Local::RunmodeDeclare;

use base 'CGI::Application::Plugin::RunmodeDeclare';

sub parse_proto {
    my $ctx = shift;
    my ($proto) = @_;
    $proto ||= '';

    # Do all the signature parsing here
    my %signature;
    $signature{invocant} = '$c'; # <= replaced $elf
    $signature{invocant} = $1 if $proto =~ s{^(\$.+):\s*}{};

    my @protos = split /\s*,\s*/, $proto;
    for my $idx (0..$#protos) {
        my $sig = $signature{$idx} = {};
        my $proto = $protos[$idx];

#            print STDERR "proto: $proto\n";

        $sig->{proto}               = $proto;
        $sig->{idx}                 = $idx;
        $sig->{is_at_underscore}    = $proto eq '@_';
        $sig->{is_ref_alias}        = $proto =~ s{^\\}{}x;

        $sig->{trait}   = $1 if $proto =~ s{ \s+ is \s+ (\S+) \s* }{}x;
        $sig->{default} = $1 if $proto =~ s{ \s* = \s* (.*) }{}x;

        my($sigil, $name) = $proto =~ m{^ (.)(.*) }x;
        $sig->{is_optional} = ($name =~ s{\?$}{} or $sig->{default});
        $sig->{sigil}       = $sigil;
        $sig->{name}        = $name;
    }

    # XXX At this point we could do sanity checks

    return \%signature;
}

1;