#!/usr/bin/perl

# test AJAX functions using url - cannot test javascript functions without
# don't need login for ajax functions

use Test::WWW::Mechanize::CGIApp;

use strict;
use warnings;

use Test::More tests => 118; # use Test::More 'no_plan';

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# need to login otherwise validation routines that use LIMS::Model::Roles::AuthUser
# die if no user_profile:
do_login();

=begin - can't test lab-tests by ajax any more - multi-col unqiue key in use
# (still gets tested in validation_profiles/admin.t):
# lab_tests table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&field_label=AML'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate field_label detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&field_label=NEW'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique field_label not flagged",
);
=cut

# lab_sections table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&section_name=Histology'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate section_name detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&section_name=FISH'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique section_name not flagged",
);

=begin - can't test screen_description by ajax now - multi-col unique key - moved to admin/screen.t:
# screens table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&screen_description=AML'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate screen description detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&screen_description=APML'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique screen description not flagged",
);
=cut

# user_functions table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&function_name=register'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate function_name detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&function_name=authorise'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique function_name not flagged",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&function_detail=register requests'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate function_detail detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&function_detail=authorisation description'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique function_name not flagged",
);

# user_groups table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_name=su'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate group_name detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_name=mla'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique group_name not flagged",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_label=SuperUser'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate group_label detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_label=MLA'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique group_label not flagged",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_detail=SuperUser description'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate group_detail detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_detail=MLA description'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique group_detail not flagged",
);

# user_locations table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&location_name=HMDS'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate location_name detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&location_name=York'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique location_name not flagged",
);

# users table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&username=admin'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate username detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&username=guest'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique username not flagged",
);

# registration:
{
    my $is_valid_date_string
        = '&is_valid_date_day=1&is_valid_date_month=13&is_valid_date_year=1923';
    $mech->get_ok('/ajax?fname=do_ajax&args=foo' . $is_valid_date_string);

    $mech->content_is(
        dfv_format('invalid_date'),
        'ajax function: invalid date detected',
    );
}
{
    my $is_valid_date_string
        = '&is_valid_date_day=1&is_valid_date_month=1&is_valid_date_year=23';
    $mech->get_ok('/ajax?fname=do_ajax&args=foo' . $is_valid_date_string);

    $mech->content_is(
        dfv_format('year_digits'),
        'ajax function: invalid year format detected',
    );
}
{
    my $is_valid_date_string
        = '&is_valid_date_day=1&is_valid_date_month=1&is_valid_date_year=1223';
    $mech->get_ok('/ajax?fname=do_ajax&args=foo' . $is_valid_date_string);

    $mech->content_is(
        get_dfv_message('centurian'), # not formatted as dfv_format()
        'ajax function: age > 100 detected',
    );
}
{
    my $is_valid_date_string
        = '&is_valid_date_day=1&is_valid_date_month=1&is_valid_date_year=2223';
    $mech->get_ok('/ajax?fname=do_ajax&args=foo' . $is_valid_date_string);

    $mech->content_is(
        get_dfv_message('future_date'), # not formatted as dfv_format()
        'ajax function: future date detected',
    );
}
{
    my $is_valid_date_string
        = '&is_valid_date_day=1&is_valid_date_month=1&is_valid_date_year=1923';
    $mech->get_ok('/ajax?fname=do_ajax&args=foo' . $is_valid_date_string);

    $mech->content_is(
        'OK', # not formatted as dfv_format()
        'ajax function: valid date detected',
    );
}

# requests:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_request_no=1'); # warn $mech->content;
{
    $mech->content_is(
        dfv_format('not_unique'),
        'ajax function: duplicate lab_number detected',
    );
}

$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_request_no=3'); # warn $mech->content;

$mech->content_is(
    'OK',
    "ajax function: unique lab_number not flagged",
);

# specimens:
my @valid_specimens = (
    'pb',
    'pb,lu',
    'pb, lu',
    'pb, lu bmat',
    'pb lu, bmat',
    'pb,lu,bma',
    'pb  lu bmat',
    'bmat.pb', # previously valid but due to issue with RDBO 0.800 - now OK with 0.802 & change to split() definition
    'bma, pb. lu',
);

my @invalid_specimens = (
    'bm',
    'pb,bm',
    'bmati', # requires RDBO 0.802 patch
    'pb.bmats',
);

foreach (@valid_specimens) {
    $mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_specimen='.$_); # warn $mech->content;

    $mech->content_is(
        'OK',
        'ajax function: valid specimen code',
    );
}

{
    foreach (@invalid_specimens) {
        $mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_specimen='.$_); 

        $mech->content_is(
            dfv_format('invalid_entry'),
            'ajax function: invalid specimen code',
        );
    }
}

# invalid nhs_number:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_nhsno=1234567890');
$mech->content_is(
    dfv_format('invalid_entry'),
    'ajax function: invalid nhs number',
);

# valid nhs_number:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_nhsno=0123456789');
$mech->content_is(
    'OK',
    'ajax function: valid nhs number',
);

# valid nhs_number - can handle spaces:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_nhsno=012 345 6789');
$mech->content_is(
    'OK',
    'ajax function: valid nhs number with spaces',
);

# valid & unique nhs_number:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_and_unique_nhsno=8888888888');
$mech->content_is(
    'OK',
    'ajax function: valid & unique nhs number',
);

# valid & unique nhs_number - can handle spaces:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_and_unique_nhsno=888 888 8888');
$mech->content_is(
    'OK',
    'ajax function: valid & unique nhs number with spaces',
);

# find referrers:
# /ajax/get_referrers?source_id=39;referrer_name=foo

# clinicians:
$mech->get_ok('/ajax/get_clinicians?source_id=1;referrer_name=cut');
$mech->content_contains(
    q!<rs id="C7654321" info="General Surgery">Cutter S</rs>!,
    'ajax function: expected clinician retrieved',
);

# diagnoses:
$mech->get_ok('/ajax/get_diagnoses?name=CLL');                  # print_and_exit; 
$mech->content_contains(
    q!<rs id="2" info="Lymphoproliferative [9823/3]">CLL</rs>!,
    'ajax function: expected diagnosis retrieved',
);                                                             

# sources:
{
    my $src = 'Newtown General';

    $mech->get_ok('/ajax/get_referral_sources?hospital='.$src);
    $mech->content_contains(
        q!<rs id="1" info="ABC01">Newtown General Infirmary</rs>!,
        'ajax function: expected location retrieved',
    );
}

# get practice from gp:
$mech->get_ok('/ajax/get_practice_from_gp?name=Black DE'); # warn $mech->content;
$mech->content_contains(
    "Black DE, The Surgery, Newtown, NT1 1NT",
    'ajax function: expected GP details retrieved',
);

# parent organisation for hospital:
$mech->get_ok('/ajax/get_parent_organisations?organisation=Newtown');
$mech->content_contains(
    q!<rs id="1" info="ABC">NEWTOWN NHS TRUST</rs>!,
    'ajax function: expected hospital parent organisation retrieved',
); 

# parent organisation for practice:
$mech->get_ok('/ajax/get_parent_organisations?practice=B12345');
$mech->content_contains(
    q!<rs id="2" info="B12345">OLD SURGERY, NT1 1TN</rs>!,
    'ajax function: expected practice parent organisation retrieved',
);

# parent organisation for practice (same as above, using name):
$mech->get_ok('/ajax/get_parent_organisations?practice=Old Surgery');
$mech->content_contains(
    q!<rs id="2" info="B12345">OLD SURGERY, NT1 1TN</rs>!,
    'ajax function: expected practice parent organisation retrieved',
);

# email_addresses:
$mech->get_ok('/ajax/get_email_addresses?address=user');
$mech->content_contains(
    qq!<rs id="user\@anywhere.net" info="">user\@anywhere.net</rs>!,
    'ajax function: expected email address retrieved',
);

# error_code:
$mech->get_ok('/ajax?fname=do_ajax&args=A&error_code=A'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate error_code detected",
);

# referral_source:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&organisation_code=B12345'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate organisation_code detected",
);
$mech->get_ok('/ajax?fname=do_ajax&args=foo&ref_source_name=Newtown General Infirmary'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate referral_source detected",
);


# parent_organisation:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&parent_code=B12345'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate parent_code detected",
);
$mech->get_ok('/ajax?fname=do_ajax&args=foo&parent_description=NEWTOWN NHS TRUST'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate parent_organisation description detected",
);

# audit_option:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&audit_options=Anaemia'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate audit_option detected",
);

# diagnosis
$mech->get_ok('/ajax?fname=do_ajax&args=foo&new_diagnosis=RAEB'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate diagnosis detected",
);

# email_address:
$mech->get_ok('/ajax/get_email_addresses?address=us'); # warn $mech->content;
$mech->content_contains(
    qq!<rs id="user\@anywhere.net" info="">user\@anywhere.net</rs>!,
    "ajax function: expected email address retrieved"
);
