package LIMS::DB::UserFunction;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'user_functions',

    columns => [
        id              => { type => 'serial', not_null => 1 },
        function_name   => { type => 'varchar', length => 20 },
        function_detail => { type => 'varchar', length => 255 },
        active	        => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'function_detail' ],
        [ 'function_name' ],
    ],

    relationships => [
        user_group_function => {
            class      => 'LIMS::DB::UserGroupFunction',
            column_map => { id => 'function_id' },
            type       => 'one to many',
        },

        user_permission => {
            class      => 'LIMS::DB::UserPermission',
            column_map => { id => 'function_id' },
            type       => 'one to many',
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2, braces => 'bsd');

__PACKAGE__->meta->make_manager_class('user_functions');

1;
