package LIMS::Controller::Roles::Dashboard;

use Moose::Role;
use Data::Dumper;

has dashboard_data => (
	is  	=> 'ro',
	isa 	=> 'HashRef',
	traits  => ['Hash'],
	default => sub { {} },
	handles => { set_dashboard_data => 'set' },
);

sub dashboard_view {
    my $self = shift;
    # is authorisation is use ?
    my $has_authorisation = $self->model('Base')->does_authorisation();
    $self->tt_params( has_authorisation => $has_authorisation );
    
    { # urgent
        my %args = ( status_query => 'urgent' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( urgent => $n );
    }
    { # unscreened
        my %args = ( status_query => 'unscreened' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( unscreened => $n );
    }
    { # unreported
        my %args = (
            status_query => 'unreported',
            duration     => $self->cfg('settings')->{unreported_duration},
        ); # warn Dumper \%args;
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( unreported => $n );
    }
# warn 'unreported, tests complete ===========================================';
    { # unreported, tests complete
        my %args = ( status_query => 'unreported_tests_complete' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( unreported_tests_complete => $n );
    }
# warn 'reported, unauthorised ===============================================';
    if ( $has_authorisation ) { # reported, unauthorised (only if in use):
        my %args = ( status_query => 'unauthorised' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( unauthorised => $n );
    }
 # warn 'reported/authorised, request status incomplete =======================';
    { # reported/authorised request status incomplete
        my %args = ( status_query => 'incomplete' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( incomplete => $n );
    }
# warn 'reported/authorised; tests complete ==================================';
    { # reported/authorised; tests complete
        my %args = ( status_query => 'complete' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( complete => $n );
    }
# warn 'incomplete lab-tests =================================================';
    { # incomplete lab-tests:
        my $data = $self->model('LabTest')->get_incomplete_lab_tests();
        $self->set_dashboard_data( incomplete_section_tests => $data );
    }
	{ # function to calculate totals from lab-test status entries:
		my $sub = sub {
			my $test = shift; # warn Dumper $test; # hashref of status => count
			my $i; $i += $test->{$_} for keys %$test; # warn $i;
			return $i;
		};
		$self->set_dashboard_data( sum_this => $sub );
	}
	{ # function to get all status values in use for lab-section:
		my $sub = sub {
			my $section = shift; # warn Dumper $section; # HoH
			my %h;
			while ( my ($test, $d) = each %$section ) { # $d is hashref of status => counts
				$h{$_}++ for keys %$d;
			} # warn Dumper [ keys %h ];
			return [ sort new_first keys %h ];
		};
		$self->set_dashboard_data( get_status_vals => $sub );
	}
    # local dashboard views:
    if ( my $yml = $self->get_yaml_file('local_dashboard') ) { # warn Dumper $yml; # AoH
        my %h;
        while ( my($view, $d) = each %$yml ) { # warn Dumper $d;
            my $n = $self->model('LabTest')
                ->get_incomplete_request_lab_tests_count($d);
            $h{$view} = $n;
        } # warn Dumper \%h;
        $self->set_dashboard_data( local_dashboard => \%h );
    }
}

# return 'new' as 1st entry (gets same chart colour), then ascii sort ($a cmp $b):
sub new_first { # warn Dumper [$a, $b];
	# http://www.perlfect.com/articles/sorting.shtml
	return $a eq 'new'
		? -1
		: $b eq 'new'
			? 1
			: lc $a cmp lc $b;
}

1;
