#!/usr/bin/perl

# requires presence of config/.local/additional_tests.yml file, or skips tests

use Test::WWW::Mechanize::CGIApp;
use Test::Builder::Tester;

use Data::Dumper;

use strict;
use warnings;

use constant TESTS => 26;

use Test::More tests => TESTS;
# use Test::More 'no_plan';

=begin: tests:
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $yaml = get_yaml('additional_tests'); # warn Dumper $yaml; exit;

SKIP: {
    skip('these tests require config/.local/settings/additional_tests.yml file',TESTS) unless $yaml;
    do_all_tests();
}

sub do_all_tests {

my $mech = get_mech();

# get list of diagnoses from $yaml:
my @diagnoses = keys %$yaml; # warn Dumper \@diagnoses; exit;

my $new_diagnosis = $diagnoses[0]; # warn $new_diagnosis;
my $lab_test = $yaml->{$new_diagnosis}; # warn Dumper $lab_test; 

do_login();

my $dbh;
eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

# register data for auto_authorisation:
my $dbix = get_dbix();

# need to see if 'require_spell_check' is required:
my $spell_check_required = is_spell_check_required(); # warn $spell_check_required;

# just add 1st diagnosis from $yaml:
$dbix->insert('diagnoses', {
    name => $new_diagnosis, diagnostic_category_id => 1, active => 'yes',
});

# lab tests:
{
    my %h = ( # common lab_test fields:
        lab_section_id => 1,
        test_type => 'test',
		has_results => 'no',
        is_active => 'yes',
    ); 
    while ( my($id, $test) = each %$lab_test ) {
        # skip if already exists:
        next if $dbix->query('select 1 from lab_tests where id = ?', $id)->list;
        $test =~ s/\s//g; # eliminate spaces
        
        @h{ qw(id field_label test_name) } = ( $id, $test, lc $test); # MUST USE SUPPLIED ID
        $dbix->insert('lab_tests', \%h);
    }
}

# register new:
$mech->get_ok('/request/add_new/2');
{
    $mech->submit_form(
        fields => {
            request_number => 3,
            specimen => 'PB',
            referrer_code => 'C1234567',
        },
    );                                                        # print_and_exit();
    
    $mech->has_tag(
        h3 => 'New request successful',
    );
}

# screen request:
$mech->get_ok('/screen/=/3');                                 # print_and_exit();
{
    $mech->field(screen_id => 2); # PNH
    $mech->field(option_id => 1);
    $mech->submit();                                          # print_and_exit();
    
    $mech->has_tag_like(
        p => qr(Screened as PNH), 
        'OK: expected screen term found',
    );    													 #  print_and_exit();
}

# sign out test:
$mech->get_ok('/worklist/display/1?display_format=Data+Entry'); # print_and_exit();
{
    $mech->field(request_lab_test_id => 1);
    $mech->field(status_option_id => 2);
    $mech->submit();                                          # print_and_exit();

    $mech->has_tag_like(
        p => qr(records updated successfully),
        'OK: update success',
    );                                                        # print_and_exit();
    
    for ( qw/PNH complete/ ) {
        $mech->has_tag(td => $_);
    }														 # print_and_exit();	
}

# report - don't auto-request test (to demonstrate no [pending] fields):
$mech->get_ok('/report/=/3');                                # print_and_exit();
{
    my %report = (
        status  => 'default',
        clinical_details => 'some details here',
        gross_description => 'gross description here',
        comment => 'morphology comment here',
        specimen_quality => 'adequate',
        diagnosis_id => 2, # doesn't auto-request tests
    );

    $mech->form_name('reportForm');
    $mech->submit_form(fields => \%report);                  # print_and_exit();
    $mech->submit_form(form_name =>'reportForm') if $spell_check_required;
    lacks_dfv_errors();                                      #  print_and_exit();

    $mech->has_tag_like(
        p => qr(record updated successfully),
        'OK: update success',
    );                                                       # print_and_exit();

    # check 'reported by':
    $mech->has_tag_like(
        p => qr(Reported by),
        'OK: reporter information displayed'
    );
    
	# no pending tests:
    {
        test_out( 'not ok 1 - foo' );
        test_fail( +1 );
        $mech->has_tag_like( span => qr(\[pending\]), 'foo' );
        test_test( 'OK: no pending lab-tests' );              # print_and_exit();
	}
}
# change diagnosis to one auto-requesting tests:
$mech->get_ok('/report/=/3');                                 # print_and_exit();
{
    $mech->form_name('reportForm');
    $mech->field(diagnosis_id => 3); # auto-requests lab-test
    $mech->field(option_id => 1);
    $mech->submit();                                          # print_and_exit();
    $mech->submit_form(form_name =>'reportForm') if $spell_check_required;
    lacks_dfv_errors();                                       # print_and_exit();
      
    $mech->has_tag_like(
        td => qr($new_diagnosis),
        'OK: changed diagnosis found',
    );                                                        # print_and_exit();

    $mech->has_tag_like(
        p => qr(record updated successfully),
        'OK: update success',
    );                                                        # print_and_exit();

	# check have requested test:
    $mech->has_tag_like(
        span => qr(\[pending\]),
        'OK: new requested test'
    );														  # print_and_exit();
}
# check history:
$mech->get_ok('/history/=/3');                                # print_and_exit();
{
    my $sql = 'select field_label from lab_tests where id = ?';
    my @test_ids = keys %$lab_test; # warn Dumper \@test_ids;
    
    # just test 1st one in case only 1 new test
    $dbix->query($sql, $test_ids[0])->into(my $field_label); # warn $field_label;
    
    $mech->has_tag_like(
        td => qr(auto-requested $field_label triggered by diagnosis),
        'OK: expected history entry'
    );														  # print_and_exit();    
}
do_logout();
}