#!/usr/bin/perl

=begin -------------------------------------------------------------------------
missing request forms from data-files dir > 2 working days after registration
=cut ---------------------------------------------------------------------------

use strict;
use warnings;

my $JUST_TESTING = 0; # email to ra.jones only

################################################################################
my @recipients = qw( douglas bagguley raj );
my $duration = 2; # how many working days since registration date
################################################################################

BEGIN {
    use FindBin qw($Bin); # warn $Bin;
    use lib (
        "$Bin/../../../lib",
        '/home/raj/perl5/lib/perl5',
    );
}

use Data::Dumper;
use LIMS::Local::ScriptHelpers;

# get tools from LIMS::Local::ScriptHelpers:
my $tools = LIMS::Local::ScriptHelpers->new();
$tools->test_only($JUST_TESTING);

my $config  = $tools->config(); 
my $dbix    = $tools->dbix();

# get date $duration working days ago:
my $date = _get_date(); # warn $date->dmy; exit;

# path to static/image_server:
my $files_dir = $tools->path_to_app_root . '/static/image_server';
    
my $sql = q!SELECT request_number, year FROM requests WHERE
	DATE(created_at) = ? ORDER BY year, request_number!;
my $result = $dbix->query($sql, $date->ymd);

my @missing = ();
while ( my $vars = $result->hash ) { # warn Dumper $vars;
    my $file = _get_filename($vars); # warn Dumper $filename;
    next if -e $file;
    push @missing, $vars;
}

exit unless @missing; # warn Dumper @missing;

my $msg = join "\n", map {
        join '/', ( $_->{request_number}, $_->{year} - 2000 );
    } @missing;

my %mail = (		
    message => $msg,
	config  => $config,
    subject => 'Missing request forms registered ' . $date->dmy,
); # warn Dumper \%mail; exit;

$tools->send_mail(\%mail, \@recipients);

sub _get_date { # doesn't consider public holidays
    my $dt = $tools->date_subtract( days => $duration );

    # day 6 is Saturday, day 7 is Sunday
    if ( $dt->day_of_week > 5 ) { # if it falls on weekend:
        $dt->subtract( days => 2 ); # subtract 2 days 
    } # warn Dumper $dt;
    
    return $dt;
}

sub _get_filename {
	my $vars = shift;
	
    my $req_num = $vars->{request_number};
    my $yyyy    = $vars->{year};
    my $yy      = $vars->{year} - 2000;
    
    # 1-99 = 0, 100-199 = 1, 200-299 = 2, etc
    my $i = int $req_num / 100; # warn $i;
    
    my $min = 100 * $i || 1; # default to 1 if 0; 1, 100, 200, 300, etc
    my $max = 100 * $i + 99; # 99, 199, 299, etc

    my $filename = sprintf '%s/%s/%s-%s/%s/%s_%s_request_form.pdf',
		$files_dir, $yyyy, $min, $max, $req_num, $yy, $req_num;

    return $filename;
}