package LIMS::Model::Roles::HistoryAction;

# provides 'action' for Role::ReportUpdate & Role::RequestUpdate
# allows both Roles to be used together by any parent class

use Moose::Role;
use Data::Dumper;

has actions => (
    is         => 'ro',
    isa        => 'ArrayRef[Str]',
    default    => sub { [] },
    lazy    => 1,
	traits  => ['Array'],
	handles => {
		add_to_actions => 'push',
        reset_actions  => 'clear',
		all_actions    => 'elements',
	},
);

sub do_request_history {
    my $self = shift; # warn Dumper $self->all_actions;
    
    my $request_id = $self->form_data->{_request_id};
    my $user_id    = $self->user_profile->{id};

    my %data = (
        request_id => $request_id,
        user_id    => $user_id,
    );
    for my $action ($self->all_actions) { # warn $action;
        $action = substr($action, 0, 255) if length $action > 255;
        $data{action} = $action; # warn Dumper \%data;
        LIMS::DB::RequestHistory->new(%data)->save;
    }
}

1;