package LIMS::DB::RequestSpecimen;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup (
    table   => 'request_specimen',

    columns => [
        request_id  => { type => 'integer', not_null => 1 },
        specimen_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'specimen_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },

        specimen => {
            class       => 'LIMS::DB::Specimen',
            key_columns => { specimen_id => 'id' },
        },
    ],
);

#=cut

#__PACKAGE__->meta->table('request_specimen');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2);

__PACKAGE__->meta->make_manager_class('request_specimens');

1;
