# generated automatically by script/make_classes.pl

#---------------------------------------------------------------------------
package LIMS::DefaultsAndRange;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'defaults_and_ranges',

    columns => [
        param_id    => { type => 'integer', not_null => 1 },
        lower_limit => { type => 'numeric', precision => 10, scale => 2 },
        upper_limit => { type => 'numeric', precision => 10, scale => 2 },
        default     => { type => 'numeric', precision => 10, scale => 2 },
        lower_flag  => { type => 'numeric', precision => 10, scale => 2 },
        upper_flag  => { type => 'numeric', precision => 10, scale => 3 },
        units       => { type => 'varchar', length => 255 },
    ],

    primary_key_columns => [ 'param_id' ],

    foreign_keys => [
        param => {
            class       => 'LIMS::LabParam',
            key_columns => { param_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Diagnos;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'diagnoses',

    columns => [
        diagnosis_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'diagnosis_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::FollowupOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'followup_options',

    columns => [
        id     => { type => 'integer', not_null => 1 },
        option => { type => 'varchar', length => 20 },
        label  => { type => 'varchar', length => 25 },
    ],

    primary_key_columns => [ 'id' ],

    relationships => [
        request_followup => {
            class      => 'LIMS::RequestFollowup',
            column_map => { id => 'followup_option_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabParam;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_params',

    columns => [
        id            => { type => 'integer', not_null => 1 },
        param_name    => { type => 'varchar', default => '', length => 25, not_null => 1 },
        field_label   => { type => 'varchar', default => '', length => 255, not_null => 1 },
        field_type    => { type => 'enum', check_in => [ 'menu', 'int', 'decimal' ], default => 'int' },
        department_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'param_name' ],

    foreign_keys => [
        department => {
            class       => 'LIMS::ResultType',
            key_columns => { department_id => 'id' },
        },
    ],

    relationships => [
        defaults_and_range => {
            class                => 'LIMS::DefaultsAndRange',
            column_map           => { id => 'param_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        request_results => {
            class      => 'LIMS::RequestResult',
            column_map => { id => 'param_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::MenuOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'menu_options',

    columns => [
        field_name => { type => 'varchar', length => 255, not_null => 1 },
        detail     => { type => 'varchar', length => 255, not_null => 1 },
    ],

    primary_key_columns => [ 'field_name', 'detail' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::NonParticipantPractice;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'non_participant_practice',

    columns => [
        practice_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'practice_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::NotificationEvent;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'notification_events',

    columns => [
        id   => { type => 'integer', not_null => 1 },
        days => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'days' ],

    relationships => [
        request_notification => {
            class      => 'LIMS::RequestNotification',
            column_map => { id => 'notification_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientAlternateAddress;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_alternate_address',

    columns => [
        patient_id => { type => 'integer', not_null => 1 },
        address    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        post_code  => { type => 'varchar', default => '', length => 8, not_null => 1 },
    ],

    primary_key_columns => [ 'patient_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientDispatchDetail;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_dispatch_detail',

    columns => [
        patient_id  => { type => 'integer', not_null => 1 },
        dispatch_to => { type => 'enum', check_in => [ 'home', 'alternate', 'GP' ], default => 'home', not_null => 1 },
    ],

    primary_key_columns => [ 'patient_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PracticeBloodTube;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'practice_blood_tube',

    columns => [
        practice_id => { type => 'integer', not_null => 1 },
        tube_type   => { type => 'enum', check_in => [ 'vacutainer', 'monovette' ] },
        time        => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'practice_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::QuestionnaireAdenopathy;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'questionnaire_adenopathy',

    columns => [
        request_id         => { type => 'integer', not_null => 1 },
        cervical_swelling  => { type => 'enum', check_in => [ 'Y', 'N' ] },
        axillary_swelling  => { type => 'enum', check_in => [ 'Y', 'N' ] },
        abdominal_swelling => { type => 'enum', check_in => [ 'Y', 'N' ] },
        inguinal_swelling  => { type => 'enum', check_in => [ 'Y', 'N' ] },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::QuestionnaireDetail;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'questionnaire_details',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        field_id   => { type => 'varchar', length => 255, not_null => 1 },
        details    => { type => 'varchar', length => 255 },
    ],

    primary_key_columns => [ 'request_id', 'field_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::QuestionnaireDetailField;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'questionnaire_detail_fields',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        field_name => { type => 'varchar', length => 25 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::QuestionnaireEq5d;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'questionnaire_eq5d',

    columns => [
        request_id     => { type => 'integer', not_null => 1 },
        mobility       => { type => 'enum', check_in => [ 'A', 'B', 'C' ] },
        self_care      => { type => 'enum', check_in => [ 'A', 'B', 'C' ] },
        usual_activity => { type => 'enum', check_in => [ 'A', 'B', 'C' ] },
        discomfort     => { type => 'enum', check_in => [ 'A', 'B', 'C' ] },
        anxiety        => { type => 'enum', check_in => [ 'A', 'B', 'C' ] },
        health_index   => { type => 'integer' },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::QuestionnairePain;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'questionnaire_pain',

    columns => [
        request_id           => { type => 'integer', not_null => 1 },
        rib_pain             => { type => 'enum', check_in => [ 'none', 'mild', 'moderate', 'severe' ] },
        back_pain            => { type => 'enum', check_in => [ 'none', 'mild', 'moderate', 'severe' ] },
        arm_pain             => { type => 'enum', check_in => [ 'none', 'mild', 'moderate', 'severe' ] },
        leg_pain             => { type => 'enum', check_in => [ 'none', 'mild', 'moderate', 'severe' ] },
        persistent_rib_pain  => { type => 'enum', check_in => [ 'Y', 'N' ] },
        persistent_back_pain => { type => 'enum', check_in => [ 'Y', 'N' ] },
        persistent_arm_pain  => { type => 'enum', check_in => [ 'Y', 'N' ] },
        persistent_leg_pain  => { type => 'enum', check_in => [ 'Y', 'N' ] },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::QuestionnaireService;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'questionnaire_service',

    columns => [
        request_id             => { type => 'integer', not_null => 1 },
        transport_arrangements => { type => 'varchar', default => 'FDefault', length => 25 },
        transport_difficulty   => { type => 'enum', check_in => [ 'Y', 'N' ] },
        location_preference    => { type => 'enum', check_in => [ 'GP', 'clinic', 'not stated', 'no preference' ] },
        waiting_duration       => { type => 'integer' },
        excessive_wait         => { type => 'enum', check_in => [ 'Y', 'N' ] },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::QuestionnaireSymptom;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'questionnaire_symptoms',

    columns => [
        request_id              => { type => 'integer', not_null => 1 },
        weight                  => { type => 'float', precision => 32 },
        weight_loss             => { type => 'enum', check_in => [ 'Y', 'N' ] },
        night_sweats            => { type => 'enum', check_in => [ 'none', 'occasional', 'frequent', 'drenching' ] },
        persistent_night_sweats => { type => 'enum', check_in => [ 'Y', 'N' ] },
        serious_infection       => { type => 'enum', check_in => [ 'Y', 'N' ] },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::QuestionnaireTreatment;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'questionnaire_treatment',

    columns => [
        request_id        => { type => 'integer', not_null => 1 },
        hospital_referral => { type => 'enum', check_in => [ 'Y', 'N' ] },
        new_medication    => { type => 'enum', check_in => [ 'Y', 'N' ] },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestFollowup;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_followup',

    columns => [
        request_id         => { type => 'integer', not_null => 1 },
        followup_option_id => { type => 'integer', default => '0', not_null => 1 },
        time               => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        followup_option => {
            class       => 'LIMS::FollowupOption',
            key_columns => { followup_option_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestNotification;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_notification',

    columns => [
        request_id      => { type => 'integer', not_null => 1 },
        notification_id => { type => 'integer', not_null => 1 },
        time            => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'notification_id', 'request_id' ],

    foreign_keys => [
        notification => {
            class       => 'LIMS::NotificationEvent',
            key_columns => { notification_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestPackDispatch;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_pack_dispatch',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        pack_due   => { type => 'date' },
        pack_sent  => { type => 'date' },
        return_due => { type => 'date' },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestResult;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_results',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        param_id   => { type => 'integer', not_null => 1 },
        result     => { type => 'varchar', default => '', length => 255, not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'param_id' ],

    foreign_keys => [
        param => {
            class       => 'LIMS::LabParam',
            key_columns => { param_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ResultType;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'result_types',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 25, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    relationships => [
        lab_params => {
            class      => 'LIMS::LabParam',
            column_map => { id => 'department_id' },
            type       => 'one to many',
        },
    ],
);

1;

