package LIMS::DB::PreRegistrationSpecimen;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'pre_registration_specimen',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        pre_reg_id    => { type => 'integer', default => '0', not_null => 1 },
        specimen_code => { type => 'character', length => 2, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'pre_reg_id', 'specimen_code' ],
    
    foreign_keys => [
        pre_reg => {
            class       => 'LIMS::DB::PreRegistration',
            key_columns => { pre_reg_id => 'id' },
        },
    ],

    relationships => [
        pre_registration_lab_test => {
            class      => 'LIMS::DB::PreRegistrationLabTest',
            column_map => { id => 'reg_specimen_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('pre_registration_specimens');

1;