package LIMS::DB::LinkedLabTest;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'linked_lab_test',

    columns => [
        lab_test_id    => { type => 'integer', default => '0', not_null => 1 },
        linked_test_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'lab_test_id', 'linked_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },
        linked_lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { linked_test_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('linked_lab_tests');

1;
