package LIMS::DB::RequestConsent;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_consent',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        consent_id => { type => 'integer', not_null => 1 },
        # don't call this 'consent' or get DB::ConsentOption error (? clashes with fk name):
        status    => { type => 'enum', check_in => [ 'yes', 'no' ],
            default => 'no', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'consent_id' ],

    foreign_keys => [
        consent => {
            class       => 'LIMS::DB::ConsentOption',
            key_columns => { consent_id => 'id' },
        },
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('request_consents');

1;

