package LIMS::DB::RequestStorage;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'request_storage',

    columns => [
        vialId        => { type => 'varchar', length => 10, not_null => 1 },
        request_id    => { type => 'integer', not_null => 1 },
        specimen_id   => { type => 'integer', not_null => 1 },
        sample        => { type => 'varchar', length => 25, not_null => 1 },
        volume        => { type => 'integer', not_null => 0 },
        concentration => { type => 'integer', not_null => 0 },
        source        => { type => 'varchar', length => 25, not_null => 1 },
        method        => { type => 'varchar', length => 25, not_null => 0 },
        rack_id       => { type => 'integer', not_null => 0 },
        vial_location => { type => 'varchar', length => 3 },
        created_at    => { type => 'timestamp', not_null => 1 },
        signed_out    => { type => 'timestamp' },
    ],

    primary_key_columns => [ 'vialId' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },

        specimen => {
            class       => 'LIMS::DB::Specimen',
            key_columns => { specimen_id => 'id' },
        },
        
        rack => {
            class       => 'LIMS::DB::StorageRack',
            key_columns => { rack_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_storage');

1;