#!/usr/bin/env perl

BEGIN { # set active db to production - default is test
    use FindBin qw($Bin); # warn 'BIN:'.$Bin;

    #$ENV{RDB_DOMAIN} = 'development'; # if using __PACKAGE__->default_domain( $ENV{RDB_DOMAIN}) in LIMS::DB
    $ENV{ROSEDB_DEVINIT} = $Bin . '/../config/rosedb_devinit_devel.pl'; # overrides default db test
    # switch LIMS::RDBO $Rose::DB::Object::Debug on:
    $ENV{RDBO_DEBUG} = 1;
    # flag for QueryLog:
    $ENV{DEVEL_SERVER} = 1;
    # set REPORT_HTML flag - server operates in single-process mode so calling img in url
    # for PDF generation fails:
    $ENV{REPORT_HTML} = 1;
    # option to set centre at command line:
    $ENV{CENTRE} = $ARGV[0] if $ARGV[0];
}

#use Plack::Middleware::ReverseProxy;
use Plack::Builder;

use lib $Bin . '/../lib';
use LIMS::Dispatch;
use CGI::Application::Server;

my $server = CGI::Application::Server->new();
$server->document_root($Bin . '/../static');
$server->entry_points( { '/hmds' => 'LIMS::Dispatch' } );

builder {
#    enable 'ReverseProxy'; # so original server addr. used instead of localhost
	$server->run;
}

