package LIMS::DB::ReportNotification;

use strict;

use base qw(LIMS::RDBO);

my @type = qw(referrer hospital organisation);

__PACKAGE__->meta->setup(
    table   => 'report_notification',

    columns => [
        id                 => { type => 'integer', not_null => 1 },
        name               => { type => 'varchar', default => '', length => 50, not_null => 1 },
        type               => { type => 'enum', check_in => \@type, not_null => 1 },
        department_id      => { type => 'integer' },
        identifier         => { type => 'varchar', default => '', length => 50, not_null => 1 },
        contact_address    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active          => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'identifier', 'contact_address' ],

    foreign_keys => [
        department => {
            class       => 'LIMS::DB::HospitalDepartment',
            key_columns => { department_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('report_notifications');

1;
