use Modern::Perl;

# extracts data from request_storage table for Syncona pilot project. Uses
# hmrn_pilot_manifest spreadsheet as a template to populate required cols

use Spreadsheet::WriteExcel::Simple;
use Data::Printer;
use FindBin; # warn $FindBin::Bin;

use lib '/home/raj/apps/HILIS4/lib';
use LIMS::Local::ScriptHelpers;
use LIMS::Local::Utils;

my $tools = LIMS::Local::ScriptHelpers->new();
my $dbix  = $tools->dbix();
$dbix->lc_columns = 0; # preserve col case

my $out_file  = "$FindBin::Bin/manifest.xls";

#===============================================================================
# use Spreadsheet::Read;
# my $book = ReadData("$FindBin::Bin/hmrn_pilot_manifest.xls"); # p($book); exit;

my $xl = Spreadsheet::WriteExcel::Simple->new;

my $headers = header(); # p($headers); exit;
$xl->write_bold_row($headers); # p(@headers); exit;

my $sql = query();
my $result = $dbix->query($sql);

my %h; # hashref of plateId / location => request_storage table data
while ( my $ref = $result->hash ) { # p($ref); next;
    my $location = $ref->{location} or die p($ref);
    my $plateId  = $ref->{plateId}  or die p($ref);
    
    # remove leading zeros from fluidx-generated well to match syncona format (eg A2):
    $location = ( $1 . int $2 ) if $location =~ /([A-H])(\d+)/; # warn $location;

    $h{$plateId}{$location} = $ref;    
} # p(%h); exit;

# get 1st 3 cols of syncona manifest (plateId, wellId, sampleId):
my @sangar_cols = map { [ split "\t" ] } grep chomp, <DATA>; # p(@sangar_cols); exit;

ROW:
for my $row(@sangar_cols) { # $row = arrayref
    my ($plateId, $well, $sampleId) = @$row; # p($sampleId);
    # next ROW to skip empty, or do "if (my $ref = [...])" to preserve empty rows:
    my $ref = $h{$plateId}{$well} || next ROW;
    
    $ref->{lab_no} = sprintf '%s/%02d',
        $ref->{request_number}, $ref->{year} - 2000; # p $ref->{lab_no};
    
    # only require SupplierSampleName, Gender, TaxonID & CommonName
    @{$row}[3, 7, 26, 27] = ( @{$ref}{qw(vialId gender)}, 9606, 'Homo Sapien' );
    # additional fields for our use:
    @{$row}[11, 31, 32] = ( @{$ref}{ qw(source specimen_code lab_no) } );
    $xl->write_row($row);
    
=begin # don't need all these
    push @$row, (
        $lab_ref, # sample name
        'HMRN pilot', # cohort
        $ref->{volume},
        $ref->{concentration},
        $ref->{gender},
        'UK',
        'Yorkshire',
        'N/A', # ethnicity
        $ref->{source}, # DNA source
        $ref->{year}, # only need year of registration
        $ref->{stored}, # SHOULD BE DNA EXTRACTION DATE
        'No', # control ?
        'No', # resubmitted ?
        $ref->{method}, # of DNA extration
        'No', # purified ?
        'N/A', # purification method
        'Promega', # concentration determination method
        '4C', # DNA storage temp
        'N/A', # mother
        'N/A', # father
        'N/A', # sibling
        'N/A', # GC content
        'N/A', # public name
        9606, # taxon ID
        'Homo Sapien', # common name
        '??', # sample description
        'N/A', # strain
        'N/A', # sample visibility
        $ref->{specimen_code}, # sample type
        '??', # sample accession no ? vialID, request.id, lab_ref
        $sampleId, # sanger sample/donor ID
        'N/A', # phenotype
    );
=cut
}

$xl->save( $out_file );

sub query {
    return q!
    select
        case 
            when sr.plateId = '50050662' then 'DN349449Q'
            when sr.plateId = '50050675' then 'DN349450J'
            when sr.plateId = '50050670' then 'DN349448P'
            when sr.plateId = '50007214' then 'DN349451K'
            else sr.plateId end as 'plateId',
        rs.vialId, rs.vial_location as location, r.request_number, r.year, 
        year(rs.created_at) as 'stored', s.sample_code as 'specimen_code',
        case when p.gender = 'U' then p.first_name else p.gender end as gender,        
        rs.sample, rs.volume, rs.concentration, rs.source, rs.method,
        rv.diagnosis        
    from request_storage rs
        join requests r on rs.request_id = r.id
        join ( patient_case pc join patients p on pc.patient_id = p.id )
            on r.patient_case_id = pc.id
        join storage_racks sr on rs.rack_id = sr.id
        join specimens s on rs.specimen_id = s.id
        join authorised_reports_view rv on rv.id = r.id
    where signed_out is not null
    order by sr.id, rs.vial_location!;
}

sub header {
    my @rows = _header();
    # insert line-breaks as per original spreadsheet format:
    for (@rows) { s/ /\n/g ; s/~/ /g }; # break on space, recover protected spaces
    return \@rows;
}

sub _header {
    return split "\n", <<EOF;
SANGER~PLATE~ID
WELL
SANGER~SAMPLE~ID
SUPPLIER SAMPLE NAME
COHORT
VOLUME (ul)
CONC. (ng/ul)
GENDER
COUNTRY~OF ORIGIN
GEOGRAPHICAL REGION
ETHNICITY
DNA SOURCE
DATE~OF~SAMPLE COLLECTION~(MM/YY or~YYYY~only)
DATE~OF~DNA EXTRACTION~(MM/YY or~YYYY~only)
IS~SAMPLE~A CONTROL?
IS RE-SUBMITTED SAMPLE?
DNA EXTRACTION METHOD
SAMPLE PURIFIED?
PURIFICATION METHOD
CONCENTRATION DETERMINED~BY
DNA~STORAGE CONDITIONS
MOTHER (optional)
FATHER (optional)
SIBLING (optional)
GC CONTENT
PUBLIC NAME
TAXON ID
COMMON NAME
SAMPLE DESCRIPTION
STRAIN
SAMPLE VISIBILITY
SAMPLE TYPE
SAMPLE~ACCESSION NUMBER~(optional)
DONOR~ID~(required for~EGA)
PHENOTYPE~(required for~EGA)
EOF
}

__DATA__
DN349446N	A1	hmrn_pilot5878942
DN349446N	B1	hmrn_pilot5878943
DN349446N	C1	hmrn_pilot5878944
DN349446N	D1	hmrn_pilot5878945
DN349446N	E1	hmrn_pilot5878946
DN349446N	F1	hmrn_pilot5878947
DN349446N	G1	hmrn_pilot5878948
DN349446N	H1	hmrn_pilot5878949
DN349446N	A2	hmrn_pilot5878950
DN349446N	B2	hmrn_pilot5878951
DN349446N	C2	hmrn_pilot5878952
DN349446N	D2	hmrn_pilot5878953
DN349446N	E2	hmrn_pilot5878954
DN349446N	F2	hmrn_pilot5878955
DN349446N	G2	hmrn_pilot5878956
DN349446N	H2	hmrn_pilot5878957
DN349446N	A3	hmrn_pilot5878958
DN349446N	B3	hmrn_pilot5878959
DN349446N	C3	hmrn_pilot5878960
DN349446N	D3	hmrn_pilot5878961
DN349446N	E3	hmrn_pilot5878962
DN349446N	F3	hmrn_pilot5878963
DN349446N	G3	hmrn_pilot5878964
DN349446N	H3	hmrn_pilot5878965
DN349446N	A4	hmrn_pilot5878966
DN349446N	B4	hmrn_pilot5878967
DN349446N	C4	hmrn_pilot5878968
DN349446N	D4	hmrn_pilot5878969
DN349446N	E4	hmrn_pilot5878970
DN349446N	F4	hmrn_pilot5878971
DN349446N	G4	hmrn_pilot5878972
DN349446N	H4	hmrn_pilot5878973
DN349446N	A5	hmrn_pilot5878974
DN349446N	B5	hmrn_pilot5878975
DN349446N	C5	hmrn_pilot5878976
DN349446N	D5	hmrn_pilot5878977
DN349446N	E5	hmrn_pilot5878978
DN349446N	F5	hmrn_pilot5878979
DN349446N	G5	hmrn_pilot5878980
DN349446N	H5	hmrn_pilot5878981
DN349446N	A6	hmrn_pilot5878982
DN349446N	B6	hmrn_pilot5878983
DN349446N	C6	hmrn_pilot5878984
DN349446N	D6	hmrn_pilot5878985
DN349446N	E6	hmrn_pilot5878986
DN349446N	F6	hmrn_pilot5878987
DN349446N	G6	hmrn_pilot5878988
DN349446N	H6	hmrn_pilot5878989
DN349446N	A7	hmrn_pilot5878990
DN349446N	B7	hmrn_pilot5878991
DN349446N	C7	hmrn_pilot5878992
DN349446N	D7	hmrn_pilot5878993
DN349446N	E7	hmrn_pilot5878994
DN349446N	F7	hmrn_pilot5878995
DN349446N	G7	hmrn_pilot5878996
DN349446N	H7	hmrn_pilot5878997
DN349446N	A8	hmrn_pilot5878998
DN349446N	B8	hmrn_pilot5878999
DN349446N	C8	hmrn_pilot5879000
DN349446N	D8	hmrn_pilot5879001
DN349446N	E8	hmrn_pilot5879002
DN349446N	F8	hmrn_pilot5879003
DN349446N	G8	hmrn_pilot5879004
DN349446N	H8	hmrn_pilot5879005
DN349446N	A9	hmrn_pilot5879006
DN349446N	B9	hmrn_pilot5879007
DN349446N	C9	hmrn_pilot5879008
DN349446N	D9	hmrn_pilot5879009
DN349446N	E9	hmrn_pilot5879010
DN349446N	F9	hmrn_pilot5879011
DN349446N	G9	hmrn_pilot5879012
DN349446N	H9	hmrn_pilot5879013
DN349446N	A10	hmrn_pilot5879014
DN349446N	B10	hmrn_pilot5879015
DN349446N	C10	hmrn_pilot5879016
DN349446N	D10	hmrn_pilot5879017
DN349446N	E10	hmrn_pilot5879018
DN349446N	F10	hmrn_pilot5879019
DN349446N	G10	hmrn_pilot5879020
DN349446N	H10	hmrn_pilot5879021
DN349446N	A11	hmrn_pilot5879022
DN349446N	B11	hmrn_pilot5879023
DN349446N	C11	hmrn_pilot5879024
DN349446N	D11	hmrn_pilot5879025
DN349446N	E11	hmrn_pilot5879026
DN349446N	F11	hmrn_pilot5879027
DN349446N	G11	hmrn_pilot5879028
DN349446N	H11	hmrn_pilot5879029
DN349446N	A12	hmrn_pilot5879030
DN349446N	B12	hmrn_pilot5879031
DN349446N	C12	hmrn_pilot5879032
DN349446N	D12	hmrn_pilot5879033
DN349446N	E12	hmrn_pilot5879034
DN349446N	F12	hmrn_pilot5879035
DN349446N	G12	hmrn_pilot5879036
DN349446N	H12	hmrn_pilot5879037
DN349447O	A1	hmrn_pilot5879038
DN349447O	B1	hmrn_pilot5879039
DN349447O	C1	hmrn_pilot5879040
DN349447O	D1	hmrn_pilot5879041
DN349447O	E1	hmrn_pilot5879042
DN349447O	F1	hmrn_pilot5879043
DN349447O	G1	hmrn_pilot5879044
DN349447O	H1	hmrn_pilot5879045
DN349447O	A2	hmrn_pilot5879046
DN349447O	B2	hmrn_pilot5879047
DN349447O	C2	hmrn_pilot5879048
DN349447O	D2	hmrn_pilot5879049
DN349447O	E2	hmrn_pilot5879050
DN349447O	F2	hmrn_pilot5879051
DN349447O	G2	hmrn_pilot5879052
DN349447O	H2	hmrn_pilot5879053
DN349447O	A3	hmrn_pilot5879054
DN349447O	B3	hmrn_pilot5879055
DN349447O	C3	hmrn_pilot5879056
DN349447O	D3	hmrn_pilot5879057
DN349447O	E3	hmrn_pilot5879058
DN349447O	F3	hmrn_pilot5879059
DN349447O	G3	hmrn_pilot5879060
DN349447O	H3	hmrn_pilot5879061
DN349447O	A4	hmrn_pilot5879062
DN349447O	B4	hmrn_pilot5879063
DN349447O	C4	hmrn_pilot5879064
DN349447O	D4	hmrn_pilot5879065
DN349447O	E4	hmrn_pilot5879066
DN349447O	F4	hmrn_pilot5879067
DN349447O	G4	hmrn_pilot5879068
DN349447O	H4	hmrn_pilot5879069
DN349447O	A5	hmrn_pilot5879070
DN349447O	B5	hmrn_pilot5879071
DN349447O	C5	hmrn_pilot5879072
DN349447O	D5	hmrn_pilot5879073
DN349447O	E5	hmrn_pilot5879074
DN349447O	F5	hmrn_pilot5879075
DN349447O	G5	hmrn_pilot5879076
DN349447O	H5	hmrn_pilot5879077
DN349447O	A6	hmrn_pilot5879078
DN349447O	B6	hmrn_pilot5879079
DN349447O	C6	hmrn_pilot5879080
DN349447O	D6	hmrn_pilot5879081
DN349447O	E6	hmrn_pilot5879082
DN349447O	F6	hmrn_pilot5879083
DN349447O	G6	hmrn_pilot5879084
DN349447O	H6	hmrn_pilot5879085
DN349447O	A7	hmrn_pilot5879086
DN349447O	B7	hmrn_pilot5879087
DN349447O	C7	hmrn_pilot5879088
DN349447O	D7	hmrn_pilot5879089
DN349447O	E7	hmrn_pilot5879090
DN349447O	F7	hmrn_pilot5879091
DN349447O	G7	hmrn_pilot5879092
DN349447O	H7	hmrn_pilot5879093
DN349447O	A8	hmrn_pilot5879094
DN349447O	B8	hmrn_pilot5879095
DN349447O	C8	hmrn_pilot5879096
DN349447O	D8	hmrn_pilot5879097
DN349447O	E8	hmrn_pilot5879098
DN349447O	F8	hmrn_pilot5879099
DN349447O	G8	hmrn_pilot5879100
DN349447O	H8	hmrn_pilot5879101
DN349447O	A9	hmrn_pilot5879102
DN349447O	B9	hmrn_pilot5879103
DN349447O	C9	hmrn_pilot5879104
DN349447O	D9	hmrn_pilot5879105
DN349447O	E9	hmrn_pilot5879106
DN349447O	F9	hmrn_pilot5879107
DN349447O	G9	hmrn_pilot5879108
DN349447O	H9	hmrn_pilot5879109
DN349447O	A10	hmrn_pilot5879110
DN349447O	B10	hmrn_pilot5879111
DN349447O	C10	hmrn_pilot5879112
DN349447O	D10	hmrn_pilot5879113
DN349447O	E10	hmrn_pilot5879114
DN349447O	F10	hmrn_pilot5879115
DN349447O	G10	hmrn_pilot5879116
DN349447O	H10	hmrn_pilot5879117
DN349447O	A11	hmrn_pilot5879118
DN349447O	B11	hmrn_pilot5879119
DN349447O	C11	hmrn_pilot5879120
DN349447O	D11	hmrn_pilot5879121
DN349447O	E11	hmrn_pilot5879122
DN349447O	F11	hmrn_pilot5879123
DN349447O	G11	hmrn_pilot5879124
DN349447O	H11	hmrn_pilot5879125
DN349447O	A12	hmrn_pilot5879126
DN349447O	B12	hmrn_pilot5879127
DN349447O	C12	hmrn_pilot5879128
DN349447O	D12	hmrn_pilot5879129
DN349447O	E12	hmrn_pilot5879130
DN349447O	F12	hmrn_pilot5879131
DN349447O	G12	hmrn_pilot5879132
DN349447O	H12	hmrn_pilot5879133
DN349448P	A1	hmrn_pilot5879134
DN349448P	B1	hmrn_pilot5879135
DN349448P	C1	hmrn_pilot5879136
DN349448P	D1	hmrn_pilot5879137
DN349448P	E1	hmrn_pilot5879138
DN349448P	F1	hmrn_pilot5879139
DN349448P	G1	hmrn_pilot5879140
DN349448P	H1	hmrn_pilot5879141
DN349448P	A2	hmrn_pilot5879142
DN349448P	B2	hmrn_pilot5879143
DN349448P	C2	hmrn_pilot5879144
DN349448P	D2	hmrn_pilot5879145
DN349448P	E2	hmrn_pilot5879146
DN349448P	F2	hmrn_pilot5879147
DN349448P	G2	hmrn_pilot5879148
DN349448P	H2	hmrn_pilot5879149
DN349448P	A3	hmrn_pilot5879150
DN349448P	B3	hmrn_pilot5879151
DN349448P	C3	hmrn_pilot5879152
DN349448P	D3	hmrn_pilot5879153
DN349448P	E3	hmrn_pilot5879154
DN349448P	F3	hmrn_pilot5879155
DN349448P	G3	hmrn_pilot5879156
DN349448P	H3	hmrn_pilot5879157
DN349448P	A4	hmrn_pilot5879158
DN349448P	B4	hmrn_pilot5879159
DN349448P	C4	hmrn_pilot5879160
DN349448P	D4	hmrn_pilot5879161
DN349448P	E4	hmrn_pilot5879162
DN349448P	F4	hmrn_pilot5879163
DN349448P	G4	hmrn_pilot5879164
DN349448P	H4	hmrn_pilot5879165
DN349448P	A5	hmrn_pilot5879166
DN349448P	B5	hmrn_pilot5879167
DN349448P	C5	hmrn_pilot5879168
DN349448P	D5	hmrn_pilot5879169
DN349448P	E5	hmrn_pilot5879170
DN349448P	F5	hmrn_pilot5879171
DN349448P	G5	hmrn_pilot5879172
DN349448P	H5	hmrn_pilot5879173
DN349448P	A6	hmrn_pilot5879174
DN349448P	B6	hmrn_pilot5879175
DN349448P	C6	hmrn_pilot5879176
DN349448P	D6	hmrn_pilot5879177
DN349448P	E6	hmrn_pilot5879178
DN349448P	F6	hmrn_pilot5879179
DN349448P	G6	hmrn_pilot5879180
DN349448P	H6	hmrn_pilot5879181
DN349448P	A7	hmrn_pilot5879182
DN349448P	B7	hmrn_pilot5879183
DN349448P	C7	hmrn_pilot5879184
DN349448P	D7	hmrn_pilot5879185
DN349448P	E7	hmrn_pilot5879186
DN349448P	F7	hmrn_pilot5879187
DN349448P	G7	hmrn_pilot5879188
DN349448P	H7	hmrn_pilot5879189
DN349448P	A8	hmrn_pilot5879190
DN349448P	B8	hmrn_pilot5879191
DN349448P	C8	hmrn_pilot5879192
DN349448P	D8	hmrn_pilot5879193
DN349448P	E8	hmrn_pilot5879194
DN349448P	F8	hmrn_pilot5879195
DN349448P	G8	hmrn_pilot5879196
DN349448P	H8	hmrn_pilot5879197
DN349448P	A9	hmrn_pilot5879198
DN349448P	B9	hmrn_pilot5879199
DN349448P	C9	hmrn_pilot5879200
DN349448P	D9	hmrn_pilot5879201
DN349448P	E9	hmrn_pilot5879202
DN349448P	F9	hmrn_pilot5879203
DN349448P	G9	hmrn_pilot5879204
DN349448P	H9	hmrn_pilot5879205
DN349448P	A10	hmrn_pilot5879206
DN349448P	B10	hmrn_pilot5879207
DN349448P	C10	hmrn_pilot5879208
DN349448P	D10	hmrn_pilot5879209
DN349448P	E10	hmrn_pilot5879210
DN349448P	F10	hmrn_pilot5879211
DN349448P	G10	hmrn_pilot5879212
DN349448P	H10	hmrn_pilot5879213
DN349448P	A11	hmrn_pilot5879214
DN349448P	B11	hmrn_pilot5879215
DN349448P	C11	hmrn_pilot5879216
DN349448P	D11	hmrn_pilot5879217
DN349448P	E11	hmrn_pilot5879218
DN349448P	F11	hmrn_pilot5879219
DN349448P	G11	hmrn_pilot5879220
DN349448P	H11	hmrn_pilot5879221
DN349448P	A12	hmrn_pilot5879222
DN349448P	B12	hmrn_pilot5879223
DN349448P	C12	hmrn_pilot5879224
DN349448P	D12	hmrn_pilot5879225
DN349448P	E12	hmrn_pilot5879226
DN349448P	F12	hmrn_pilot5879227
DN349448P	G12	hmrn_pilot5879228
DN349448P	H12	hmrn_pilot5879229
DN349449Q	A1	hmrn_pilot5879230
DN349449Q	B1	hmrn_pilot5879231
DN349449Q	C1	hmrn_pilot5879232
DN349449Q	D1	hmrn_pilot5879233
DN349449Q	E1	hmrn_pilot5879234
DN349449Q	F1	hmrn_pilot5879235
DN349449Q	G1	hmrn_pilot5879236
DN349449Q	H1	hmrn_pilot5879237
DN349449Q	A2	hmrn_pilot5879238
DN349449Q	B2	hmrn_pilot5879239
DN349449Q	C2	hmrn_pilot5879240
DN349449Q	D2	hmrn_pilot5879241
DN349449Q	E2	hmrn_pilot5879242
DN349449Q	F2	hmrn_pilot5879243
DN349449Q	G2	hmrn_pilot5879244
DN349449Q	H2	hmrn_pilot5879245
DN349449Q	A3	hmrn_pilot5879246
DN349449Q	B3	hmrn_pilot5879247
DN349449Q	C3	hmrn_pilot5879248
DN349449Q	D3	hmrn_pilot5879249
DN349449Q	E3	hmrn_pilot5879250
DN349449Q	F3	hmrn_pilot5879251
DN349449Q	G3	hmrn_pilot5879252
DN349449Q	H3	hmrn_pilot5879253
DN349449Q	A4	hmrn_pilot5879254
DN349449Q	B4	hmrn_pilot5879255
DN349449Q	C4	hmrn_pilot5879256
DN349449Q	D4	hmrn_pilot5879257
DN349449Q	E4	hmrn_pilot5879258
DN349449Q	F4	hmrn_pilot5879259
DN349449Q	G4	hmrn_pilot5879260
DN349449Q	H4	hmrn_pilot5879261
DN349449Q	A5	hmrn_pilot5879262
DN349449Q	B5	hmrn_pilot5879263
DN349449Q	C5	hmrn_pilot5879264
DN349449Q	D5	hmrn_pilot5879265
DN349449Q	E5	hmrn_pilot5879266
DN349449Q	F5	hmrn_pilot5879267
DN349449Q	G5	hmrn_pilot5879268
DN349449Q	H5	hmrn_pilot5879269
DN349449Q	A6	hmrn_pilot5879270
DN349449Q	B6	hmrn_pilot5879271
DN349449Q	C6	hmrn_pilot5879272
DN349449Q	D6	hmrn_pilot5879273
DN349449Q	E6	hmrn_pilot5879274
DN349449Q	F6	hmrn_pilot5879275
DN349449Q	G6	hmrn_pilot5879276
DN349449Q	H6	hmrn_pilot5879277
DN349449Q	A7	hmrn_pilot5879278
DN349449Q	B7	hmrn_pilot5879279
DN349449Q	C7	hmrn_pilot5879280
DN349449Q	D7	hmrn_pilot5879281
DN349449Q	E7	hmrn_pilot5879282
DN349449Q	F7	hmrn_pilot5879283
DN349449Q	G7	hmrn_pilot5879284
DN349449Q	H7	hmrn_pilot5879285
DN349449Q	A8	hmrn_pilot5879286
DN349449Q	B8	hmrn_pilot5879287
DN349449Q	C8	hmrn_pilot5879288
DN349449Q	D8	hmrn_pilot5879289
DN349449Q	E8	hmrn_pilot5879290
DN349449Q	F8	hmrn_pilot5879291
DN349449Q	G8	hmrn_pilot5879292
DN349449Q	H8	hmrn_pilot5879293
DN349449Q	A9	hmrn_pilot5879294
DN349449Q	B9	hmrn_pilot5879295
DN349449Q	C9	hmrn_pilot5879296
DN349449Q	D9	hmrn_pilot5879297
DN349449Q	E9	hmrn_pilot5879298
DN349449Q	F9	hmrn_pilot5879299
DN349449Q	G9	hmrn_pilot5879300
DN349449Q	H9	hmrn_pilot5879301
DN349449Q	A10	hmrn_pilot5879302
DN349449Q	B10	hmrn_pilot5879303
DN349449Q	C10	hmrn_pilot5879304
DN349449Q	D10	hmrn_pilot5879305
DN349449Q	E10	hmrn_pilot5879306
DN349449Q	F10	hmrn_pilot5879307
DN349449Q	G10	hmrn_pilot5879308
DN349449Q	H10	hmrn_pilot5879309
DN349449Q	A11	hmrn_pilot5879310
DN349449Q	B11	hmrn_pilot5879311
DN349449Q	C11	hmrn_pilot5879312
DN349449Q	D11	hmrn_pilot5879313
DN349449Q	E11	hmrn_pilot5879314
DN349449Q	F11	hmrn_pilot5879315
DN349449Q	G11	hmrn_pilot5879316
DN349449Q	H11	hmrn_pilot5879317
DN349449Q	A12	hmrn_pilot5879318
DN349449Q	B12	hmrn_pilot5879319
DN349449Q	C12	hmrn_pilot5879320
DN349449Q	D12	hmrn_pilot5879321
DN349449Q	E12	hmrn_pilot5879322
DN349449Q	F12	hmrn_pilot5879323
DN349449Q	G12	hmrn_pilot5879324
DN349449Q	H12	hmrn_pilot5879325
DN349450J	A1	hmrn_pilot5879326
DN349450J	B1	hmrn_pilot5879327
DN349450J	C1	hmrn_pilot5879328
DN349450J	D1	hmrn_pilot5879329
DN349450J	E1	hmrn_pilot5879330
DN349450J	F1	hmrn_pilot5879331
DN349450J	G1	hmrn_pilot5879332
DN349450J	H1	hmrn_pilot5879333
DN349450J	A2	hmrn_pilot5879334
DN349450J	B2	hmrn_pilot5879335
DN349450J	C2	hmrn_pilot5879336
DN349450J	D2	hmrn_pilot5879337
DN349450J	E2	hmrn_pilot5879338
DN349450J	F2	hmrn_pilot5879339
DN349450J	G2	hmrn_pilot5879340
DN349450J	H2	hmrn_pilot5879341
DN349450J	A3	hmrn_pilot5879342
DN349450J	B3	hmrn_pilot5879343
DN349450J	C3	hmrn_pilot5879344
DN349450J	D3	hmrn_pilot5879345
DN349450J	E3	hmrn_pilot5879346
DN349450J	F3	hmrn_pilot5879347
DN349450J	G3	hmrn_pilot5879348
DN349450J	H3	hmrn_pilot5879349
DN349450J	A4	hmrn_pilot5879350
DN349450J	B4	hmrn_pilot5879351
DN349450J	C4	hmrn_pilot5879352
DN349450J	D4	hmrn_pilot5879353
DN349450J	E4	hmrn_pilot5879354
DN349450J	F4	hmrn_pilot5879355
DN349450J	G4	hmrn_pilot5879356
DN349450J	H4	hmrn_pilot5879357
DN349450J	A5	hmrn_pilot5879358
DN349450J	B5	hmrn_pilot5879359
DN349450J	C5	hmrn_pilot5879360
DN349450J	D5	hmrn_pilot5879361
DN349450J	E5	hmrn_pilot5879362
DN349450J	F5	hmrn_pilot5879363
DN349450J	G5	hmrn_pilot5879364
DN349450J	H5	hmrn_pilot5879365
DN349450J	A6	hmrn_pilot5879366
DN349450J	B6	hmrn_pilot5879367
DN349450J	C6	hmrn_pilot5879368
DN349450J	D6	hmrn_pilot5879369
DN349450J	E6	hmrn_pilot5879370
DN349450J	F6	hmrn_pilot5879371
DN349450J	G6	hmrn_pilot5879372
DN349450J	H6	hmrn_pilot5879373
DN349450J	A7	hmrn_pilot5879374
DN349450J	B7	hmrn_pilot5879375
DN349450J	C7	hmrn_pilot5879376
DN349450J	D7	hmrn_pilot5879377
DN349450J	E7	hmrn_pilot5879378
DN349450J	F7	hmrn_pilot5879379
DN349450J	G7	hmrn_pilot5879380
DN349450J	H7	hmrn_pilot5879381
DN349450J	A8	hmrn_pilot5879382
DN349450J	B8	hmrn_pilot5879383
DN349450J	C8	hmrn_pilot5879384
DN349450J	D8	hmrn_pilot5879385
DN349450J	E8	hmrn_pilot5879386
DN349450J	F8	hmrn_pilot5879387
DN349450J	G8	hmrn_pilot5879388
DN349450J	H8	hmrn_pilot5879389
DN349450J	A9	hmrn_pilot5879390
DN349450J	B9	hmrn_pilot5879391
DN349450J	C9	hmrn_pilot5879392
DN349450J	D9	hmrn_pilot5879393
DN349450J	E9	hmrn_pilot5879394
DN349450J	F9	hmrn_pilot5879395
DN349450J	G9	hmrn_pilot5879396
DN349450J	H9	hmrn_pilot5879397
DN349450J	A10	hmrn_pilot5879398
DN349450J	B10	hmrn_pilot5879399
DN349450J	C10	hmrn_pilot5879400
DN349450J	D10	hmrn_pilot5879401
DN349450J	E10	hmrn_pilot5879402
DN349450J	F10	hmrn_pilot5879403
DN349450J	G10	hmrn_pilot5879404
DN349450J	H10	hmrn_pilot5879405
DN349450J	A11	hmrn_pilot5879406
DN349450J	B11	hmrn_pilot5879407
DN349450J	C11	hmrn_pilot5879408
DN349450J	D11	hmrn_pilot5879409
DN349450J	E11	hmrn_pilot5879410
DN349450J	F11	hmrn_pilot5879411
DN349450J	G11	hmrn_pilot5879412
DN349450J	H11	hmrn_pilot5879413
DN349450J	A12	hmrn_pilot5879414
DN349450J	B12	hmrn_pilot5879415
DN349450J	C12	hmrn_pilot5879416
DN349450J	D12	hmrn_pilot5879417
DN349450J	E12	hmrn_pilot5879418
DN349450J	F12	hmrn_pilot5879419
DN349450J	G12	hmrn_pilot5879420
DN349450J	H12	hmrn_pilot5879421
DN349451K	A1	hmrn_pilot5879422
DN349451K	B1	hmrn_pilot5879423
DN349451K	C1	hmrn_pilot5879424
DN349451K	D1	hmrn_pilot5879425
DN349451K	E1	hmrn_pilot5879426
DN349451K	F1	hmrn_pilot5879427
DN349451K	G1	hmrn_pilot5879428
DN349451K	H1	hmrn_pilot5879429
DN349451K	A2	hmrn_pilot5879430
DN349451K	B2	hmrn_pilot5879431
DN349451K	C2	hmrn_pilot5879432
DN349451K	D2	hmrn_pilot5879433
DN349451K	E2	hmrn_pilot5879434
DN349451K	F2	hmrn_pilot5879435
DN349451K	G2	hmrn_pilot5879436
DN349451K	H2	hmrn_pilot5879437
DN349451K	A3	hmrn_pilot5879438
DN349451K	B3	hmrn_pilot5879439
DN349451K	C3	hmrn_pilot5879440
DN349451K	D3	hmrn_pilot5879441
DN349451K	E3	hmrn_pilot5879442
DN349451K	F3	hmrn_pilot5879443
DN349451K	G3	hmrn_pilot5879444
DN349451K	H3	hmrn_pilot5879445
DN349451K	A4	hmrn_pilot5879446
DN349451K	B4	hmrn_pilot5879447
DN349451K	C4	hmrn_pilot5879448
DN349451K	D4	hmrn_pilot5879449
DN349451K	E4	hmrn_pilot5879450
DN349451K	F4	hmrn_pilot5879451
DN349451K	G4	hmrn_pilot5879452
DN349451K	H4	hmrn_pilot5879453
DN349451K	A5	hmrn_pilot5879454
DN349451K	B5	hmrn_pilot5879455
DN349451K	C5	hmrn_pilot5879456
DN349451K	D5	hmrn_pilot5879457
DN349451K	E5	hmrn_pilot5879458
DN349451K	F5	hmrn_pilot5879459
DN349451K	G5	hmrn_pilot5879460
DN349451K	H5	hmrn_pilot5879461
DN349451K	A6	hmrn_pilot5879462
DN349451K	B6	hmrn_pilot5879463
DN349451K	C6	hmrn_pilot5879464
DN349451K	D6	hmrn_pilot5879465
DN349451K	E6	hmrn_pilot5879466
DN349451K	F6	hmrn_pilot5879467
DN349451K	G6	hmrn_pilot5879468
DN349451K	H6	hmrn_pilot5879469
DN349451K	A7	hmrn_pilot5879470
DN349451K	B7	hmrn_pilot5879471
DN349451K	C7	hmrn_pilot5879472
DN349451K	D7	hmrn_pilot5879473
DN349451K	E7	hmrn_pilot5879474
DN349451K	F7	hmrn_pilot5879475
DN349451K	G7	hmrn_pilot5879476
DN349451K	H7	hmrn_pilot5879477
DN349451K	A8	hmrn_pilot5879478
DN349451K	B8	hmrn_pilot5879479
DN349451K	C8	hmrn_pilot5879480
DN349451K	D8	hmrn_pilot5879481
DN349451K	E8	hmrn_pilot5879482
DN349451K	F8	hmrn_pilot5879483
DN349451K	G8	hmrn_pilot5879484
DN349451K	H8	hmrn_pilot5879485
DN349451K	A9	hmrn_pilot5879486
DN349451K	B9	hmrn_pilot5879487
DN349451K	C9	hmrn_pilot5879488
DN349451K	D9	hmrn_pilot5879489
DN349451K	E9	hmrn_pilot5879490
DN349451K	F9	hmrn_pilot5879491
DN349451K	G9	hmrn_pilot5879492
DN349451K	H9	hmrn_pilot5879493
DN349451K	A10	hmrn_pilot5879494
DN349451K	B10	hmrn_pilot5879495
DN349451K	C10	hmrn_pilot5879496
DN349451K	D10	hmrn_pilot5879497
DN349451K	E10	hmrn_pilot5879498
DN349451K	F10	hmrn_pilot5879499
DN349451K	G10	hmrn_pilot5879500
DN349451K	H10	hmrn_pilot5879501
DN349451K	A11	hmrn_pilot5879502
DN349451K	B11	hmrn_pilot5879503
DN349451K	C11	hmrn_pilot5879504
DN349451K	D11	hmrn_pilot5879505
DN349451K	E11	hmrn_pilot5879506
DN349451K	F11	hmrn_pilot5879507
DN349451K	G11	hmrn_pilot5879508
DN349451K	H11	hmrn_pilot5879509
DN349451K	A12	hmrn_pilot5879510
DN349451K	B12	hmrn_pilot5879511
DN349451K	C12	hmrn_pilot5879512
DN349451K	D12	hmrn_pilot5879513
DN349451K	E12	hmrn_pilot5879514
DN349451K	F12	hmrn_pilot5879515
DN349451K	G12	hmrn_pilot5879516
DN349451K	H12	hmrn_pilot5879517
