#
#===============================================================================
#
#  DESCRIPTION:
#
#===============================================================================
package TestsFor::LIMS::Local::RfC;
use Test::Class::Moose;

use Modern::Perl;
use utf8;

use DDP;
use Try::Tiny;

with 'Test::Class::Moose::Role::AutoUse';

use FindBin qw($RealBin);
use LIMS::Local::Config;
use lib 'lib';    # t/lib
use TestUtils;
use LIMS::Local::ScriptHelpers;
my $config = LIMS::Local::Config->instance;
my $tools  = LIMS::Local::ScriptHelpers->new;
my $dbix;
my $rfc;

sub test_startup {
    my @tables_used_in_test = qw/users rfc/;
    $dbix = TestUtils::load_data( $config, \@tables_used_in_test );
}

#TESTS:
## find_incomplete_rfcs with results
# find_incomplete_rfcs without results
## find_orphans with results
## find_orphans without results

## need to test more rigorously. so far this is just an example program using the test board.
sub test_some {
    my $test  = shift;
    my $class = $test->test_class;

    # create rfc object and check it
    $rfc = LIMS::Local::RfC->new( database => $dbix );
    ok( $rfc, '$rfc ok' );
    ok( ref $rfc eq 'LIMS::Local::RfC', "object created" );
    ok $rfc->tracker->can("create_issue"), "can create RFC";

    #we got 2 rfcs but they dont have cardIDs yet
    isnt( $rfc->find_incomplete_rfcs, "no cardIDs in list of rfcs yet" );

    # find them and put them in trello
    ok( my @orphans = $rfc->find_orphans, "2 orphans found" );

    ok( $rfc->recreate_issue($_), "recreated rfc not found in trello" )
      for @orphans;
    is( ()= $rfc->find_orphans,0, "0 orphans found" );
    #we got 2 rfcs but they dont have cardIDs yet
    is( my @incompletes = $rfc->find_incomplete_rfcs,2, "cardIDs now in list of rfcs" ); #2
$rfc->tracker->move_card($incompletes[0]->{remote_id}, 'complete');
$rfc->tracker->move_card($incompletes[1]->{remote_id}, 'rejected');
    ok( $rfc->update_rfcs(@incompletes),      "updated rfcs in db" );
    isnt( $rfc->find_incomplete_rfcs, "all complete" );
  TODO: {
        local $TODO = "not yet implimented";

        #move some rfcs to completed or rejected
        #then
        # update status of incomplete rfcs

    }
}

sub test_shutdown {
    my $test  = shift;
    my $class = $test->test_class;

    # tidy up test board

    try {

        # tidy up test board
        $rfc->tracker->archive_issues($_) for qw/new complete rejected/;

    }
}

1;
