package NGIS;

# common data file shared by HILIS4/t/ngis_requests.t and
# Fileuploader-D2/t/ngis_requests.t

use Moo;
use Data::Printer;
use Types::Standard 'InstanceOf';
has dbix => ( is => 'ro', required => 1, isa => InstanceOf['DBIx::Simple'] );

sub run { # new db entries:
    my $self = shift;
    my @ngis_ids = @_;

    my $ngis_id_1 = $ngis_ids[0];
    my $ngis_id_2 = $ngis_ids[1];

    my $dbix = $self->dbix; # check using correct db:
    die 'wrong db' unless $dbix->query('SELECT DATABASE()')->list eq 'lims_test';

    # GeNEQ location (check it exist or create new):
    unless ( $dbix->select( 'referral_sources', 1,
            { organisation_code => 'GENEQN' } )->list ) {
        $dbix->insert('parent_organisations', { parent_code => 'GENEQN',
            description => 'GENEQ NEWCASTLE', referral_type_id => 3 });
        my $parent_id = $self->last_insert_id('parent_organisations');
        my %h = ( display_name => 'GeNEQ Newcastle', organisation_code => 'GENEQN',
            parent_organisation_id => $parent_id, referral_type_id => 3 );
        $dbix->insert('referral_sources', \%h);
    }
    unless ( $dbix->select( 'referral_sources', 1,
            { organisation_code => 'GENEQS' } )->list ) {
        $dbix->insert('parent_organisations', { parent_code => 'GENEQS',
            description => 'GENEQ SHEFFIELD', referral_type_id => 3 });
        my $parent_id = $self->last_insert_id('parent_organisations');
        my %h = ( display_name => 'GeNEQ Sheffield', organisation_code => 'GENEQS',
            parent_organisation_id => $parent_id, referral_type_id => 3 );
        $dbix->insert('referral_sources', \%h);
    }
    # referrer & referrer_department for GeNEQ location (check exist or create new):
    unless ( $dbix->select( 'referrers', 1,
            { national_code => 'C2345678' })->list ) {
        $dbix->insert('referrers', { name => 'White A', national_code => 'C2345678',
            referral_type_id => 1 });
        my $ref_id = $self->last_insert_id('referrers');
        $dbix->select('parent_organisations', 'id', { parent_code => 'GENEQN' })
            ->into(my $parent_id);
        $dbix->insert('referrer_department', { parent_organisation_id => $parent_id,
            referrer_id => $ref_id, hospital_department_code => 823 }); # haem OK for this
    }
    # referrer & referrer_department for GeNEQ location (check exist or create new):
    unless ( $dbix->select( 'referrers', 1,
            { national_code => 'C3456789' })->list ) {
        $dbix->insert('referrers', { name => 'Silver A', national_code => 'C3456789',
            referral_type_id => 1 });
        my $ref_id = $self->last_insert_id('referrers');
        $dbix->select('parent_organisations', 'id', { parent_code => 'GENEQS' })
            ->into(my $parent_id);
        $dbix->insert('referrer_department', { parent_organisation_id => $parent_id,
            referrer_id => $ref_id, hospital_department_code => 823 }); # haem OK for this
    }
    # register 2 new request_form rows (if not already):
    unless ( $dbix->select('request_form', 1, {id => $ngis_id_2} )->list ) {
        my $ref_src_id = $dbix->select('referral_sources', 'id',
            { organisation_code => 'GENEQN' })->list;
        my %h = ( # patient already registered in patients:
            id => $ngis_id_2, last_name => 'brown', first_name => 'stan',
            dob => '1960-04-10', gender => 'M', nhs_number => 2222222222,
            location_name => 'GeNEQ Newcastle', location_id => $ref_src_id,
            user_id => 1, referrer => 'White A [Molecular Genetics]',
            requested_by => 'Black T'
        ); # p %h;
        $dbix->insert('request_form', \%h) or die $dbix->error;
    }
    unless ( $dbix->select('request_form', 1, {id => $ngis_id_1} )->list ) {
        my $ref_src_id = $dbix->select('referral_sources', 'id',
            { organisation_code => 'GENEQS' })->list;
        my %h = ( # patient doesn't already exist:
            id => $ngis_id_1, last_name => 'gray', first_name => 'olive',
            dob => '1966-07-11', gender => 'F', nhs_number => 3333333333,
            location_name => 'GeNEQ Sheffield', location_id => $ref_src_id,
            user_id => 1, referrer => 'Silver E [Molecular Genetics]',
            requested_by => 'Brown S'
        ); # p %h;
        $dbix->insert('request_form', \%h) or die $dbix->error;
    }
}

sub last_insert_id { $_[0]->dbix->query('select max(id) from '.$_[1])->list }

1;
