package LIMS::DB::PatientEdit;

use strict;
use warnings;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'patient_edits',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        patient_id    => { type => 'integer', not_null => 1 },
        last_name     => { type => 'varchar', length => 50 },
        first_name    => { type => 'varchar', length => 50 },
        middle_name   => { type => 'varchar', length => 50 },
        dob           => { type => 'date' },
        gender        => { type => 'enum', check_in => [ 'M', 'F', 'U' ], default => 'U' },
        nhs_number    => { type => 'varchar', length => 10 },
        user_id       => { type => 'integer', not_null => 1 },
        error_code_id => { type => 'integer', not_null => 1 },
        time          => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        error_code => {
            class       => 'LIMS::DB::ErrorCode',
            key_columns => { error_code_id => 'id' },
        },
        patient => {
            class       => 'LIMS::DB::Patient',
            key_columns => { patient_id => 'id' },
        },
        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);
#=cut

# or to see what it should be:
#__PACKAGE__->meta->table('patient_edits');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2);

__PACKAGE__->meta->make_manager_class('patient_edits');

1;

