package LIMS::Controller::Image;

use Moose;
BEGIN { extends 'LIMS::Base'; }
with (
	'LIMS::Controller::Roles::DataFile',
);
use namespace::clean -except => 'meta';
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

use Data::Dumper;

# ------------------------------------------------------------------------------
# default() should never be called direct - redirect to start page:
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->redirect( $self->query->url );
}

# ------------------------------------------------------------------------------
sub load : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

	# id param can be passed in as request.id or lab_number in format nn_nnnnn:
	my $token = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);

	my $request_data = $self->_get_request_data($token);
	my $contents     = $self->load_image_files($request_data); # arrayref of filenames
    my $settings     = $self->cfg('settings');

	my %unrestricted = map { $_ => 1 } # anyone can view:
		grep { $_ =~/\.(jpg|pdf)\Z/i } @{ $contents->{files} };

    $self->tt_params(
		unrestricted => \%unrestricted,
		contents     => $contents,
        request      => $request_data,
		mini_dir     => $self->stash->{mini_dir}, # set in load_image_files()
	);
    my $tt = $settings->{local_image_files_tt} # use local tt if configured
        ? $settings->{_centre}
        : 'default';
    return $self->tt_process("images/${tt}.tt");
}

# ------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->forbidden() unless $self->user_can('upload_data_files');

    my $request_id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);

    $self->query->param('image_file') || return $self->forward('load');

	# check file doesn't already exist:
	my $file = $self->check_image_file($request_id); # warn $file;

	if ( $file && ! $self->query->param('confirm_overwrite') ) {
		$self->tt_params( confirm_overwrite => 1 );
		return $self->forward('load');
	}

	my $rtn = $self->upload_image($request_id);

	return $rtn ? $self->error($rtn) :
		$self->redirect( $self->query->url . '/image/=/' . $request_id );
}

# ------------------------------------------------------------------------------
sub delete : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->forbidden() unless $self->user_can('upload_data_files');

	# id param can be passed in as request.id or lab_number in format nn_nnnnn:
	my $token  = $self->param('id')
    || return $self->error('no id param passed to ' . $self->get_current_runmode);

	my $marked_file = $self->param('Id')
	|| return $self->error('no Id param passed to ' . $self->get_current_runmode);

	# need confirmation:
	unless ( $self->query->param('confirm_delete') ) {
		$self->tt_params( marked_file => $marked_file );
		$self->tt_params( confirm_delete => 1 );
		return $self->forward('load');
	}

	my $request_data = $self->_get_request_data($token);

	my %args = ( request_data => $request_data, filename => $marked_file );
	my $rtn = $self->delete_image(\%args);
    if ($rtn) { # probably unlink error - Can't find a class for method 'unlink'
        $self->flash( warning => "${rtn} Please check file has been deleted." );
    }
	$self->redirect( $self->query->url . '/image/=/' . $token );
}

# ------------------------------------------------------------------------------
# returns request data as hashref:
sub _get_request_data {
	my ($self, $id_param) = @_; $self->_debug_path(); # warn Dumper $id_param;

	# id param can be passed in as request.id or lab_number in format nn_nnnnn:
	if ( $id_param =~ m!(\d{2})_(\d{1,})! ) { # does this ever happen ?
        #my $request_id = # could use this to get request_id, then get full record:
        #    $self->model('Request')->get_request_id_from_lab_number([$id_param]);
		my %request = (
			request_number => int $2,
			year		   => 2000 + $1,
			id             => $id_param, # for template 'delete' url
		); warn 'id_param:'.$id_param; # to see when this format used
		return \%request;
	}
	else {
		my $data = $self->model('Request')->get_single_request($id_param);
		return $data->as_tree(deflate => 0); # downstream process expects hashref
	}
}

1;
