#!/usr/bin/perl

use strict;
use warnings;

BEGIN {
    use FindBin qw($Bin); # warn 'BIN:'.$Bin; exit;
    # set lib paths for app:
    use lib (
		"$Bin/../lib",
        '/home/raj/perl5/lib/perl5',
	);
}

use Daemon::Control;

my %args = (
    name         => 'lantronix',
#    lsb_start   => '$syslog $remote_fs',
#    lsb_stop    => '$syslog',
    lsb_sdesc    => 'Lantronix daemon',
    lsb_desc     => 'Controls the lantronix_daemon script',
    path         => "$Bin/lantronix_daemon.pl",
    program      => "$Bin/lantronix_socket.pl",
    program_args => [ ],
    pid_file     => '/var/run/lantronix/lantronix.pid',
    stderr_file  => '/var/run/lantronix/lantronix.out',
    stdout_file  => '/var/run/lantronix/lantronix.out',
    fork         => 2,
);

Daemon::Control->new(\%args)->run;

__END__
# init.d script:
if [ -x /home/raj/apps/HILIS4/script/lantronix_daemon.pl ];
then
    /home/raj/apps/HILIS4/script/lantronix_daemon.pl $1
else
    echo "Required program /home/raj/apps/HILIS4/script/lantronix_daemon.pl not found!"
    exit 1;
fi
