#!/usr/bin/env perl

use strict;
use warnings;

use Data::Printer;
use Modern::Perl;
use AnonymiseDB;

use lib '/home/raj/perl-lib';    
use Local::DB; $Local::QueryLogger::NO_QUERY_LOGS = 1;

my $dbname = $ARGV[0] || die 'require temp db name';

my $dbix = Local::DB->dbix({ dbname => $dbname });
$dbix->lc_columns = 0;

# count nhs_numbers for pre-generation of sufficient:
my $sql = "select count(*) from patients where nhs_number is not null";
my $nhs_number_count = $dbix->query( $sql )->value; # p $nhs_number_count;

my $anonymiser = AnonymiseDB->new( nhs_number_count => $nhs_number_count );

# get all patients:
my $patient = $dbix->select("$dbname.patients", '*');

while ( my $vals = $patient->hash ) { # p $vals->{id};
    say $vals->{id} unless $vals->{id} % 100;
    $anonymiser->anonymise_patient($vals);

    my $id = $vals->{id}; # warn $p_id;
    delete $vals->{id};
    $dbix->update( "$dbname.patients", $vals, { id => $id } );
}

exit if $dbname eq 'genomics'; # need participant ID (unit_number)

# get all patient_case entries:
my $patient_case = $dbix->select("$dbname.patient_case", '*');

while ( my $vals = $patient_case->hash ) {
    $anonymiser->anonymise_unit_number($vals);

    my $id = $vals->{id}; # warn $p_id;
    delete $vals->{id};
    $dbix->update( "$dbname.patient_case", $vals, { id => $id } );
}
