#
#===============================================================================
#
#  DESCRIPTION:
#
#===============================================================================

package TestsFor::LIMS::Local::IssueTracker;
use Test::Class::Moose;
use DDP;
use Try::Tiny;

# this was only necessary for trello::lite
#use lib  'script/prereq_lib'; # make sure we are using old HTTP::Tiny


with 'Test::Class::Moose::Role::AutoUse';

use YAML::Tiny;
use FindBin qw($RealBin);

sub test_some : Tests {
    my $test  = shift;
    my $class = $test->test_class;
    my @card_ids;
    my @lists;

    my $tracker;

    {
        # _BUILD_CONFIG dies - corrupted yaml
        throws_ok {
            $tracker =
              LIMS::Local::IssueTracker->new( config_file =>
                  "$RealBin/config/settings/.leeds/issue_tracking_malformed.yml"
              );
        }
        qr/(failed to classify line|undefined value as an ARRAY reference)/,
          "died with YAML error";

        # CHECK_CONFIG dies - yaml without required key
        throws_ok{
            $tracker = LIMS::Local::IssueTracker->new( config_file =>
                    "$RealBin/config/settings/.leeds/issue_tracking_missing.yml" );
        } qr/config error/, "died with the config error";

        # correct yaml
        lives_ok {
            $tracker = LIMS::Local::IssueTracker->new( config_file =>
                  "$RealBin/../config/settings/.leeds/issue_tracking.yml" );
        }
        "correct yaml file. Plugin loaded.";

        isa_ok $tracker , "LIMS::Local::IssueTracker", "Is an LIMS::Local::IssueTracker object";

        ok( $tracker->does('MooseX::Object::Pluggable'), "does Pluggable" );
        ok( $tracker->does('LIMS::Local::Role::Trackable'), "does Trackable" );

#        my $plugin = $tracker->config->{plugin};
#        # TODO change this to whatever the plugin type is
#        print ref $tracker;
#        is $plugin, "Trello", "config set for trello";

    }

    {
       # plugin has create_issue method
        ok $tracker->can("create_issue"), "can create RFC";
        #TODO delete all posts issues and then check board is empty
        $tracker->delete_all_issues;


       # dies if given an invailid 'reason' # spelling!!
        throws_ok {
            $tracker->create_issue(
                {
                    name   => "fail",
                    desc   => "fail description",
                    reason => "invalid reason"
                }
            );
        } qr/error adding label/,
           "died with the label error";

        # create issues with all possible reasons
        while ( my ( $key, $value ) = each %{ $tracker->config->{colours} } ) {
            my $res;
            my $args = { name => $value, desc => "test1 description", reason => $key };
            lives_ok { $res = $tracker->create_issue($args) } "http status OK";
            push @card_ids, $res;

        # move the cards around a bit
            if ( ( scalar @card_ids % 2 ) == 0 ) {
                my $to_list =
                    ( scalar @card_ids % 4 ) == 0
                    ? "complete"
                    : "rejected";
                $tracker->move_card( $res, $to_list );
                my $card_status = $tracker->get_status($res);
                #TODO closed/open
                like $card_status , qr/closed|rejected/,
                     "card $res in $card_status";

        #is $card_status , "Backlog", "card $res in Backlog";
            }
            else {
                my $card_status = $tracker->get_status($res);
#        $DB::single = 1;
                is $card_status , "opened", "card $res in Backlog";
            }
        }
    }
    #TODO fails from here
    {
# handle stale or incorrect card id
        my $res = "blahblahblah";
        throws_ok {
        my $card_status = $tracker->get_status($res);
        } qr/error: can't get card/,
           "died with the *can't get card* error";
    }
    {
        # tests to die when moving cards
        throws_ok {$tracker->move_card( "id")} qr/requires destination/, "move without destination";
        throws_ok {$tracker->move_card( "badid" , "complete")} qr/can't move card/, "move with bad id";
    }

    {
        # now take list of card_ids and ask which are in complete or rejected lists

        my $complete_ids = $tracker->list_complete( \@card_ids );
        my $rejected_ids = $tracker->list_rejected( \@card_ids );

        # TODO rewrite these methods
        is scalar @{$complete_ids}, 1, "1 card in completed";
        is scalar @{$rejected_ids}, 1, "1 card in rejected";
    }
    is scalar $tracker->all_iids, 4, "4 issues on board";
    # tidy up test board
    lives_ok { $tracker->delete_all_issues; } "Archive test lists";
    is scalar $tracker->all_iids, 0, "0 issues on board";

}

1;

