# adds a line to request_history when NBT data transfered to ICE

use Data::Printer;
use lib '/home/raj/perl-lib';
use Local::DB;

$Local::QueryLogger::NO_QUERY_LOGS = 1; # don't need queries in logs dir

my $dbix = Local::DB->dbix({ dbname => 'bristol' });

my $nbt_user_id 
    = $dbix->select('users', 'id', { username => 'nbt-bhods' })->value;
my $result = $dbix->select('request_hl7_log', ['request_id', 'timestamp'],
    { response => { -like => 'Application Accept%' } });

while ( my $ref = $result->hash ) {
    my $request_id = $ref->{request_id};
    # check request_id still exists (deletion causes error):
    $dbix->select('requests', 1, { id => $request_id })->value or next;
    my %h = (
        request_id => $request_id, 
        user_id    => $nbt_user_id,
        action     => 'dispatched request data to ICE',
        time       => $ref->{timestamp},
    ); # p %h;
    $dbix->insert('request_history', \%h);
}
