package LIMS::Controller::Admin::Config::DiagnosticCategories;

use base 'LIMS::Base';
use LIMS::Local::Sugar;
use LIMS::Local::Utils;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# ------------------------------------------------------------------------------
startmode default ($errs) { # $self->stash( errs => $errs );
    $self->_debug_path($self->get_current_runmode);

    my %args = ( sort_by => $self->query->param('sort_by') || '' );

	my $diagnostic_categories
        = $self->model('Diagnosis')->get_diagnostic_categories;

    $self->tt_params(
        categories => $diagnostic_categories,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('diagnostic_categories');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode edit ($errs, $id) {
    $self->_debug_path($self->get_current_runmode); # $self->stash( errs => $errs );

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

	my $q = $self->query;

    { # diagnostic category info:
		my $data = $self->model('Diagnosis')->get_diagnostic_category($id);
		$self->tt_params( data => $data );
	}
	{ # diagnosis info:
		my %args = ( sort_by => $q->param('sort_by') || 'name' ); # def if not supplied
		my $all_diagnoses = $self->model('Diagnosis')->get_all_diagnoses(\%args);
		$self->tt_params( diagnoses => $all_diagnoses );
	}
    { # ICDO3 entries for category:
		my $query = [ diagnostic_category_id => $id ];
		my @args = ( 'ICDOSubCategory', { query => $query } );
		my $o = $self->model('Base')->get_objects(@args); # $self->debug($o);
		my %icdo3 = map { $_->icdo3 => 1 } @$o;
		$self->tt_params( icdo3 => \%icdo3 );
	}
	$self->tt_params( errs => $errs );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('diagnosis');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode configure ($id) {
	$self->_debug_path($self->get_current_runmode);

	my $q = $self->query; # warn Dumper $q->param('icdo3');
	# get list of unique ICDO3 codes (as arrayref):
	my $icdo3 = LIMS::Local::Utils::get_unique_elements([ $q->param('icdo3') ]);

	my %data = (
		diagnostic_category_id => $id,
		icdo3 => $icdo3,
	);
    my $rtn = $self->model('Diagnosis')->update_sub_category(\%data);

    return $rtn
        ? $self->error($rtn)
        : $self->redirect( $q->url . '/config/diagnostic-categories/edit/' . $id );
}

# -------------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);

	# put id (if submitted) into params() as _record_id for validation:
    if ( $id ) { # warn $id;
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('diagnostic_categories') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created:
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('Diagnosis')->update_diagnostic_categories($data); # $self->debug($data);

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/config/diagnostic-categories' );
}

1;
