#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;
use Test::Builder::Tester;

use strict;
use warnings;

use Test::More tests => 29; # use Test::More 'no_plan';

=begin # tests:
1) try to register new result summary option with no lab sections
2) register new result summary option
3) edit new result summary option
4) create new lab section with has_result_summary set no
5) test for absence of new lab section in new result summary option page
6) set new lab section has_result_summary to yes
7) test for presence of new lab section in new result summary option page
8) set new lab section is_active to no
9) test for absence of new lab section in new result summary option page
=cut

require 't/test-lib.pl';

my $mech = get_mech();

do_login();   # print $fh $mech->content; # exit;

# need to drop & re-create following tables:
foreach ( qw/lab_sections/ ) {
    drop_and_recreate($_);
}

$mech->get_ok("/config/result-summary-options");            # print_and_exit();

# check for expected error msg:
$mech->content_contains(
    get_messages('admin')->{no_sections},
    'OK: need lab sections first',
);

# add lab_section direct:
{
    my $dbix = get_dbix();
    
    my %new = (
        section_name => 'Histology',
        has_result_summary => 'yes',
        is_active => 'yes',
    );
    $dbix->insert('lab_sections', \%new);    
}

$mech->get_ok("/config/result-summary-options");            # print_and_exit();

# check no error msg:
$mech->content_lacks(
    get_messages('admin')->{no_sections},
    'OK: need lab sections first',
);                                                          # print_and_exit();

{
    $mech->field(id => 1);
    $mech->submit();                                        # print_and_exit();
    
    $mech->has_tag(
        option => 'Histology',
        'OK: expected option present',
    );
    
    $mech->form_name('result_summary_option');
    $mech->field(description => 'Carcinoma of prostate');
    $mech->submit();                                         #  print_and_exit();
    
    lacks_dfv_errors();                                     # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{create_success},
        'OK: new record succeeded',
    );                                                       # print_and_exit();        
}

# edit last entry:
{
    my $id = get_last_insert_id('result_summary_options');
    $mech->get_ok('/config/result-summary-options/edit/'.$id);  # print_and_exit();
    
    $mech->field(is_active => 'no');
    $mech->submit_form();                                       # print_and_exit();
    
    lacks_dfv_errors();                                         # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{edit_success},
        'OK: new record succeeded',
    );                                                          # print_and_exit();     
}

# new lab_section without results_summary:
$mech->get_ok("/admin/lab_section");                        # print_and_exit();
{
    my %new = (
        section_name => 'Flow screen',
        has_results_summary => 'no',
        is_active => 'yes',
    );
    $mech->submit_form(fields => \%new);                    # print_and_exit();

    $mech->content_like(
        qr(<input type="text" (.*) value="Flow screen"),
        'OK: new entry success',
    );
}

# get result summary options page back:
$mech->get_ok("/config/result-summary-options");             #print_and_exit();
{
    # has expected lab_section:
    $mech->has_tag_like(
        option => 'Histology',
        'OK: expected lab_section present',
    );
    
    # doesn't have new lab_section:
    test_out( 'not ok 1 - foo' );
    test_fail( +1 );
    $mech->has_tag_like( option => 'Flow screen', 'foo' );
    test_test( 'OK: new inactive lab section not present' );    
}

# edit new lab_section, has_results_summary -> 'yes':
$mech->get_ok("/admin/lab_section/edit/2");                    # print_and_exit();
{
    $mech->field(has_result_summary => 'yes');  
    $mech->submit_form();                                       # print_and_exit();
    
    lacks_dfv_errors();                                         # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{edit_success},
        'OK: new record succeeded',
    );                                                          # print_and_exit();     
}

# get result summary options page back:
$mech->get_ok("/config/result-summary-options");                # print_and_exit();
{
    # has new lab section now:
    $mech->has_tag_like(
        option => 'Flow screen',
        'OK: new lab_section present',
    );
}

# edit new lab_section, is_active -> 'no':
$mech->get_ok("/admin/lab_section/edit/2");                    # print_and_exit();
{
    $mech->field(is_active => 'no');  
    $mech->submit_form();                                       # print_and_exit();
    
    lacks_dfv_errors();                                         # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{edit_success},
        'OK: new record succeeded',
    );                                                          # print_and_exit();     
}

# get result summary options page back:
$mech->get_ok("/config/result-summary-options");                # print_and_exit();
{
    # now doesn't have new lab_section:
    test_out( 'not ok 1 - foo' );
    test_fail( +1 );
    $mech->has_tag_like( option => 'Flow screen', 'foo' );
    test_test( 'OK: new inactive lab section not present' );    
}

# do_logout(); logout link not available for admin function