#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;

use strict;
use warnings;

use Test::More tests => 43;
# use Test::More 'no_plan';

=begin: tests:
1) 2 new error code entries
2) re-enter both codes (permitted duplicates & not permitted duplicates)
2) new LIC
3) new error code + LIC
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

do_login();

# new error code (B):
$mech->get_ok('/search/=/1');                                 # print_and_exit();
{
    $mech->follow_link_ok(
        # {n => 8}, "Logout $_ via eighth link on page",
        { url_regex => qr(error), },
        'follow error link',
    );                                                        # print_and_exit();
    
    $mech->field(error_code_id => 2);
    $mech->submit();                                          # print_and_exit();
    
    lacks_dfv_errors();                                       # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{create_success},
        'OK: new record succeeded',
    );                                                        # print_and_exit();        
    
    foreach ( qw/B second_error/ ) {
        $mech->has_tag(
            td => $_,
            'OK: expected error details loaded'
        );
    }
    
    # check history:
    $mech->get_ok('/history/=/1');                            #  print_and_exit();
    $mech->has_tag(
        td => 'recorded error code B',
        'OK: expected history details'
    );
}

# enter error_code C:
$mech->get_ok('/error/=/1');                                   # print_and_exit();
{
    $mech->field(error_code_id => 3);
    $mech->submit();                                          # print_and_exit();
    
    lacks_dfv_errors();                                       # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{create_success},
        'OK: new record succeeded',
    );                                                        # print_and_exit();        
    
    foreach ( qw/C third_error/ ) {
        $mech->has_tag(
            td => $_,
            'OK: expected error details loaded'
        );
    }
    
    # check history:
    $mech->get_ok('/history/=/1');                             # print_and_exit();    
    $mech->has_tag(
        td => 'recorded error code C',
        'OK: expected history details'
    );
}

# re-enter code B (permitted dupicates) & C (not permitetd duplicates):
$mech->get_ok('/error/=/1');                                   # print_and_exit();
{
    # code B:
    $mech->field(error_code_id => 2);
    $mech->submit();                                          # print_and_exit();
    
    lacks_dfv_errors();                                       # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{create_success},
        'OK: new record succeeded',
    );                                                        # print_and_exit();        
    
    # code C:
    $mech->field(error_code_id => 3);
    $mech->submit();                                          # print_and_exit();
    
    lacks_dfv_errors();                                       # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{create_success},
        'OK: new record succeeded',
    );                                                        # print_and_exit();        
    
    # code B again:
    $mech->field(error_code_id => 2);
    $mech->submit();                                          # print_and_exit();
    
    lacks_dfv_errors();                                       # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{create_success},
        'OK: new record succeeded',
    );                                                        # print_and_exit();        
    # code C again:
    $mech->field(error_code_id => 3);
    $mech->submit();                                          # print_and_exit();

    # can't check history for duplicates, so do db lookup:
    my $dbix = get_dbix();
    my $sql = q!select count(*) from request_error_code where request_id = ?
        and error_code_id = ?!;
    { # code B:
        my $code_b = $dbix->query($sql, 1, 2)->list;
        is($code_b, 3, 'OK: expected number of code B entries');
    }
    { # code C:
        my $code_c = $dbix->query($sql, 1, 3)->list;
        is($code_c, 1, 'OK: expected number of code C entries');
    }
}                                                             # print_and_exit(); 

# new LIC:
$mech->get_ok('/error/=/1');                                   # print_and_exit();
{
    $mech->field(LIC => 1);
    $mech->submit();                                          # print_and_exit();

    lacks_dfv_errors();                                       # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{create_success},
        'OK: new record succeeded',
    );                                                        # print_and_exit();        

    # check history:
    $mech->get_ok('/history/=/1');                            # print_and_exit();
    $mech->has_tag(
        td => 'completed LIC',
        'OK: expected history details'
    );
}

# new error code + LIC:
$mech->get_ok('/error/=/2');
{
    $mech->field(error_code_id => 3);
    $mech->field(LIC => 1);
    $mech->submit();                                          # print_and_exit();
    
    lacks_dfv_errors();                                       # print_and_exit();
    $mech->content_contains( 
        get_messages('action')->{create_success},
        'OK: new record succeeded',
    );                                                        # print_and_exit();        
    
    # check 'em all:
    foreach ( qw/C third_error/ ) {
        $mech->has_tag(
            td => $_,
            'OK: expected error details loaded'
        );
    }
    
    # check history:
    $mech->get_ok('/history/=/2');                             # print_and_exit();
    $mech->has_tag(
        td => 'recorded error code C',
        'OK: expected history details'
    );
    $mech->has_tag(
        td => 'completed LIC',
        'OK: expected history details'
    );
}

# re-enter code B (permitted dupicates:)
do_logout();