package LIMS::DB::RequestOption;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_option',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        option_id  => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'option_id' ],

    foreign_keys => [
        option => {
            class       => 'LIMS::DB::AdditionalOption',
            key_columns => { option_id => 'id' },
        },
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

#=cut

#__PACKAGE__->meta->table('request_option');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('request_options');

1;
