package LIMS::DB::RequestExternalRef;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_external_ref',

    columns => [
        request_id         => { type => 'integer', not_null => 1 },
        external_reference => { type => 'varchar', length => 255, not_null => 1 },
        status             => { type => 'varchar', length => 25 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

#=cut

#__PACKAGE__->meta->table('request_option');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('request_external_ref');

1;
