package LIMS::Controller::Admin::Config::DiagnosticCategories;

use base 'LIMS::Base';
use LIMS::Local::Sugar;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# ------------------------------------------------------------------------------
startmode default ($errs) { # $self->stash( errs => $errs );
    $self->_debug_path($self->get_current_runmode);

    my %args = ( sort_by => $self->query->param('sort_by') || '' );

	my $diagnostic_categories
        = $self->model('Diagnosis')->get_diagnostic_categories;

    $self->tt_params(
        categories => $diagnostic_categories,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('diagnostic_categories');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode edit ($errs, $id) {
    $self->_debug_path($self->get_current_runmode); # $self->stash( errs => $errs );

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('Diagnosis')->get_diagnostic_category($id);

    $self->tt_params(
        errs => $errs,
		data => $data,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('diagnosis');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);

	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { # warn $id;
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('diagnostic_categories') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('Diagnosis')->update_diagnostic_categories($data); # $self->debug($data);

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/config/diagnostic-categories' );
}

1;