package LIMS::Controller::Roles::Resource;

use Moose::Role;
use Data::Dumper;

sub new_and_relapsed_diagnoses {
    my ($self, $ref) = @_; # org_code & followup - both optional
    
    my %h;
    
    { # get map of user locations => region_code:
        my $locations_map = $self->user_locations_map;
        $h{locations_map} = $locations_map;
    }

    # if we have an org_code to search on:
    if ( my $org_code = $ref->{org_code} ) { # warn Dumper $org_code;
        my $duration  = $ref->{duration} || 7; # default    
        my $all_cases = $ref->{all_cases}; # get everything for location

        my %args = ( duration => $duration, all_cases => $all_cases );
        # RDBO default for array(ref) is IN(??), but is very slow in _this_ query
        if ( ref $org_code eq 'ARRAY' ) { # construct a much faster RLIKE query:
            my $str = join '|', @$org_code;
            $args{org_code} = { rlike => $str }; 
        }
        elsif ( $org_code ne '%' ) { # % = all locations - doesn't need org_code param
            $args{org_code} = $org_code;
        }

        my $data = $self->model('Request')->get_new_and_relapsed_cases(\%args);
        $h{results} = $data;
=begin # fixed - see get_new_and_relapsed_cases()
        # sort data by report_history.time since Rose can't do it:
        my @sorted = sort { # warn Dumper $a->request_history->time;
            my $A = $a->request_history->[0]->time->truncate( to => 'day' ); 
            my $B = $b->request_history->[0]->time->truncate( to => 'day' );
			
            DateTime->compare( $A, $B ) # date 1st 
                || $a->year <=> $b->year # year 2nd
                    || $a->request_number <=> $b->request_number; # req_no 3rd	
        } @$data; # warn Dumper \@sorted;
        $h{results} = \@sorted;
=cut        
    }
    
    return \%h;
}

sub get_admin_messages {
    my ($self, $user_location) = @_;
    
    my $user_type = 'all'; # default to all, modify if $user_location provided:
    if ($user_location) {
        $user_type = # is user internal or external?
            $user_location eq $self->cfg('settings')->{lab_name_abbreviation}
            ? 'internal'
            : 'external';
    }
    
    my $messages = $self->model('User')->get_admin_messages($user_type);
    return $messages;
}

sub get_user_messages {
    my ($self, $user_id) = @_;
    
    my $messages = $self->model('User')->get_user_messages($user_id);
    return $messages;
}

sub get_network_locations {
	my $self = shift;
	
	my $cfg = $self->get_yaml_file('network_locations') || return 0;
	
	my $user = $self->authen->username; # warn $user;

    if ( my $network_name = $cfg->{usernames}->{$user} ) {
		my $network_locations = $cfg->{networks}->{$network_name};
		return $network_locations;
	}
	return 0;	
}

sub create_form_tokens {
    my $self = shift;
    
    my %token; # for centre & username for handing to .cgi scripts as param
    my $key = LIMS::Local::Utils::today->ymd; # so url only valid on same day
    
    { # provide a 'centre' token for request_forms.cgi to upload to correct path:
        # get centre var from config, or supply 'invalid' to cause fatal err when
        # FileUploader tries to open config so uploads don't go to wrong dir
        my $ctr = $self->cfg('settings')->{_centre} || 'invalid';
        my $str = LIMS::Local::Utils::encrypt($ctr, $key);
        $token{centre} = $str;
    }
    { # username token for online request form:
        my $username = $self->authen->username
        || return $self->error('no username'); # not sure if this works from here
        my $str = LIMS::Local::Utils::encrypt($username, $key);
        $token{username} = $str;
    } # warn Dumper \%token;
    return \%token;
}

1;