use Net::Telnet;
use Data::Printer;
use Modern::Perl;
use Time::HiRes qw(gettimeofday tv_interval);

my $host =
	'163.160.119.21';  # genomics
#	'163.160.215.218'; # hmds
my $port = 2001;

my $t0 = [gettimeofday];

 do_buffer_method(); # works for both
# do_waitfor_method(); # only reliably works for xtr-96 using /H12,(.*)/
# do_cmd_method(); # doesn't work

say sprintf '%.2f sec', tv_interval $t0, [gettimeofday];

# works for both XTR-96 & Intellicode:
sub do_buffer_method { # original HILIS method - uses buffer():
    my @args = (
        Timeout	=> 15,
        Errmode	=> 'return', # don't die (default)
		Input_Log 	=> './xtr-96.log', # uncomment to debug
    );
    my $t = connect_and_get(@args);

	# direct manipulation of buffer easier than documented methods!!
	my $ref = $t->buffer; # p $ref;
    say $t->errmsg if $t->errmsg;
	$t->close;
	do_extract(${$ref}); # send deref'd string
    say "do_buffer_method for $host";
;
}

# works for both using /H12,(.*)/ for XTR-96, and using /(.*)/ for Intellicode sometimes!!:
sub do_waitfor_method { # new HILIS method - uses waitfor():
    my @args = (
        # Timeout	=> 15, done in waitfor() now otherwise processes delay until $secs
        Errmode	=> 'return', # don't die (default)
    	Input_Log 	=> './xtr-96.log', # uncomment to debug
    );
    my $t = connect_and_get(@args);

=begin # this works for both but on 96-well only (can't use less than H12 as it'll send as soon as /$re/):
    my $re = qr{H12,(.*)}; # end of output = H12,<result>
    my ($prematch, $match) = $t->waitfor(Match => "/$re/", Timeout => undef); # no timeout
    my $output = join '', $prematch, $match;
=cut
#=begin # this (sometimes!!) works for Intellicode only (xtr-96 gives empty $output):
    my $re = qr{(.*)};
    my ($output) = $t->waitfor(Match => "/$re/", Timeout => undef); # no timeout
#=cut
    say $t->errmsg if $t->errmsg;
    $t->close; # p $output;
	do_extract($output);
    say "do_waitfor_method for $host";
}

sub do_cmd_method {
    my $t = Net::Telnet->new(@_);

    my @host = ( Host => $host, Port => $port );
    unless ( $t->open(@host) ) { # returns 1 on success, 0 on failure:
        die $t->errmsg;
    }
	my $ref;
	my @data = $t->getlines(Timeout => 30); p @data;
    my $line = $t->lastline; p $line;
	$t->dump_log();
}

sub do_extract {
	my $string = shift; # say $string; die '$string empty' unless $string;

	my ($plateId, $str)
		= $string =~ /Rack Identifier = ([A-Z0-9]+)\s+(A01,.*)/;
    say sprintf qq!cannot extract data from output: $string! and return 0 unless $str;
	$str =~ s/\s//g; # remove (arbitrary?) spaces

	my %plate_data = split /,\s?/, $str;
	p %plate_data; p $plateId;
}

sub connect_and_get {
    my $t = Net::Telnet->new(@_);

    my @host = ( Host => $host, Port => $port );
    unless ( $t->open(@host) ) { # returns 1 on success, 0 on failure:
        die $t->errmsg;
    }
    # initiate plate read:
    $t->cmd('get');

    return $t;
}

__END__

Intellicode output using:
    my $re = qr{(.*)$};
    my ($output) = $t->waitfor(Match => "/$re/", Timeout => undef);
=====================================================================

xtr-96 Connected

Reading...

Rack Identifier = SA00136849
A01, FR09988928, A02, FR09988848,  A03, FR09988856, A04, FR09988864, A05, FR09988872, A06, FR09988880, A07, FR09988888, A08, FR09988896, A09, FR09988904, A10, FR09988912, A11, FR09988920, A12, FR09988891, B01, FR09988841, B02, FR09988849, B03, FR09988857, B04, FR09988865, B05, FR09988873, B06, FR09988881, B07, FR09988889, B08, FR09988897, B09, FR09988905, B10, FR09988913, B11, FR09988921, B12, FR09988929, C01, FR09988842, C02, FR09988850, C03, FR09988858, C04, FR09988866, C05, FR09988874, C06, FR09988882, C07, FR09988890, C08, FR09988898, C09, FR09988906, C10, FR09988914, C11, FR09988922, C12, FR09988930, D01, FR09988843, D02, FR09988851, D03, FR09988859, D04, FR09988867, D05, FR09988875, D06, FR09988883, D07, FR09988847, D08, FR09988899, D09, FR09988907, D10, FR09988915, D11, FR09988923, D12, FR09988931, E01, FR09988844, E02, FR09988852, E03, FR09988860, E04, FR09988868, E05, FR09988876, E06, FR09988884, E07, FR09988892, E08, FR09988900, E09, FR09988908, E10, FR09988916, E11, FR09988924, E12, FR09988932, F01, FR09988845, F02, FR09988853, F03, FR09988861, F04, FR09988869, F05, FR09988877, F06, FR09988885, F07, FR09988893, F08, FR09988901, F09, FR09988909, F10, FR09988917, F11, FR09988925, F12, FR09988933, G01, FR09988846, G02, FR09988854, G03, FR09988862, G04, FR09988870, G05, FR09988878, G06, FR09988886, G07, FR09988894, G08, FR09988902, G09, FR09988910, G10, FR09988918, G11, FR09988926, G12, FR09988934, H01, FR09988935, H02, FR09988855, H03, FR09988863, H04, FR09988871, H05, FR09988879, H06, FR09988887, H07, FR09988895, H08, FR09988903, H09, NO TUBE, H10, 1025448211, H11, 1025448489, H12, 1025448243
=====================================================================

XTR-96 output using:
    my $re = qr{H12,(.*)$}; # end of output = H12,<result>
    my ($prematch, $match) = $t->waitfor(Match => "/$re/", Timeout => undef); # no timeout
    my $output = join '', $prematch, $match;

=====================================================================
xtr-96 ConnectedReading...Rack Identifier = SA00083770
A01,No Tube,B01,1020861345,C01,1020861346,D01,1020861347,E01,1020861348,F01,1020861349,G01,1020861350,H01,1020861351,A02,No Tube,B02,1020861353,C02,1020861354,D02,1020861355,E02,1020861356,F02,1020861357,G02,1020861358,H02,1020861359,A03,No Tube,B03,1020861361,C03,1020861362,D03,1020861363,E03,1020861364,F03,1020861365,G03,1020861366,H03,1020861367,A04,No Tube,B04,1020861369,C04,1020861370,D04,1020861371,E04,1020861372,F04,1020861373,G04,1020861374,H04,1020861375,A05,No Tube,B05,1020861377,C05,1020861378,D05,1020861379,E05,1020861380,F05,1020861381,G05,1020861382,H05,1020861383,A06,No Tube,B06,1020861385,C06,1020861386,D06,1020861387,E06,1020861388,F06,1020861389,G06,1020861390,H06,1020861391,A07,No Tube,B07,1020861393,C07,1020861394,D07,1020861395,E07,1020861396,F07,1020861397,G07,1020861398,H07,1020861399,A08,No Tube,B08,1020861401,C08,1020861402,D08,1020861403,E08,1020861404,F08,1020861405,G08,1020861406,H08,1020861407,A09,No Tube,B09,1020861409,C09,1020861410,D09,1020861411,E09,1020861412,F09,1020861413,G09,1020861414,H09,1020861415,A10,No Tube,B10,1020861417,C10,1020861418,D10,1020861419,E10,1020861420,F10,1020861421,G10,1020861422,H10,1020861423,A11,1020861424,B11,1020861425,C11,1020861426,D11,1020861427,E11,1020861428,F11,1020861429,G11,1020861430,H11,1020861431,A12,1020861432,B12,1020861433,C12,1020861434,D12,1020861435,E12,1020861436,F12,1020861437,G12,1020861438,H12,1020861439
=====================================================================
