package LIMS::DB::UserMessage;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'user_message',

    columns => [
        id           => { type => 'serial', not_null => 1 },
        recipient_id => { type => 'integer', not_null => 1 },
        sender_id    => { type => 'integer', not_null => 1 },
        message      => { type => 'text', length => 65535 },
        received     => { type => 'timestamp', not_null => 1 },
        acknowledged => { type => 'timestamp' },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        recipient => {
            class       => 'LIMS::DB::User',            
            key_columns => { recipient_id => 'id' },
        },
        sender => {
            class       => 'LIMS::DB::User',
            key_columns => { sender_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('user_messages');

1;


