package LIMS::DB::LabTestSampleType;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'lab_test_sample_type',

    columns => [
        lab_test_id    => { type => 'integer', default => '0', not_null => 1 },
        sample_type_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'sample_type_id', 'lab_test_id' ],

    foreign_keys => [
        sample_type => {
            class       => 'LIMS::DB::SampleType',
            key_columns => { sample_type_id => 'id' },
        },
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('lab_test_sample_types');

1;