package LIMS::DB::RequestLabTestStatus;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_lab_test_status',

    columns => [
        id                  => { type => 'serial', not_null => 1 },
        request_id          => { type => 'integer', default => '0', not_null => 1 },
        lab_test_id         => { type => 'integer', default => '0', not_null => 1 },
        status_option_id    => { type => 'integer', default => '1', not_null => 1 },
        user_id             => { type => 'integer', default => '0', not_null => 1 },
        time                => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'request_id', 'lab_test_id' ],
    
    foreign_keys => [
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
        
        status => {
            class       => 'LIMS::DB::LabTestStatusOption',
            key_columns => { status_option_id => 'id' },
        },
        
        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_lab_test_status');

1;