#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;
use Test::Builder::Tester;

use Data::Dumper;

use strict;
use warnings;

#use Test::More tests => 25;
 use Test::More 'no_plan';

=begin: tests:

=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

my $dbix = get_dbix();

# add new patient/request - name similar to existing:
$dbix->insert('patients', { last_name => 'green', first_name => 'alan',
    middle_name => 'michael',  dob => '1940-02-01' });
my $patient_id = get_last_insert_id('patients');
$dbix->insert('patient_case', { patient_id => $patient_id, referral_source_id => 2,
    unit_number => 1011 });
my $patient_case_id = get_last_insert_id('patient_case');
$dbix->insert('requests', { request_number => 3, year => DateTime->now->year,
    patient_case_id => $patient_case_id, referrer_department_id => 1,
    created_at => DateTime->now });
$dbix->insert('error_codes', { code => 'd', description => 'record merged',
    is_unique => 'no', active => 'yes' });

warn 'TODO';
$mech->get_ok('/admin/patient_merge/search?last_name=green');  # print_and_exit();
